/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.resultexporter;

import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.resultexporter.ResultExporter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TXTExporter
implements ResultExporter {
    private String filepath;
    private ArrayList<Entity> entities;

    public TXTExporter(String filepath, ArrayList<Entity> entities) throws FalseFileTypeException {
        this.filepath = filepath;
        this.entities = entities;
        if (!filepath.endsWith("txt")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    @Override
    public void exportResults() {
        try {
            PrintWriter writer = new PrintWriter(this.filepath, "UTF-8");
            writer.printf(" %-55s", "Entity_Name");
            writer.printf("| %-55s", "Category");
            writer.printf("| %-55s", "URIs");
            writer.printf("| %-55s", "Rank");
            writer.printf("| %-55s", "Number of Occurrences");
            writer.println();
            writer.print("============================================================================================================================================================================================================================================================");
            writer.println();
            for (Entity entity : this.entities) {
                Set<String> matchingURIs = entity.getMatchingURIs();
                if (matchingURIs.isEmpty()) {
                    writer.printf(" %-55s", entity.getName());
                    writer.printf("| %-55s", entity.getCategoryName());
                    writer.printf("| %-55s", "");
                    writer.printf("| %-55s", entity.getRank());
                    writer.printf("| %-55s", entity.getNumOfOccurrences());
                    writer.println();
                    continue;
                }
                for (String uri : matchingURIs) {
                    writer.printf(" %-55s", entity.getName());
                    writer.printf("| %-55s", entity.getCategoryName());
                    writer.printf("| %-55s", uri);
                    writer.printf("| %-55s", entity.getRank());
                    writer.printf("| %-55s", entity.getNumOfOccurrences());
                    writer.println();
                }
            }
            writer.close();
        }
        catch (Exception exc) {
            Logger.getLogger(TXTExporter.class.getName()).log(Level.SEVERE, null, exc);
        }
    }
}

