/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.resultexporter;

import gr.forth.ics.isl.xlink.Entity;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.resultexporter.ResultExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
implements ResultExporter {
    private String filepath;
    private ArrayList<Entity> entities;

    public XMLExporter(String filepath, ArrayList<Entity> entities) throws FalseFileTypeException {
        this.filepath = filepath;
        this.entities = entities;
        if (!filepath.endsWith("xml")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    @Override
    public void exportResults() {
        int i = 1;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("Entities");
            doc.appendChild(rootElement);
            for (Entity entity : this.entities) {
                Element staff = doc.createElement("Entity");
                rootElement.appendChild(staff);
                Attr attr = doc.createAttribute("id");
                attr.setValue(Integer.toString(i++));
                staff.setAttributeNode(attr);
                Element entity_name = doc.createElement("entity_name");
                entity_name.appendChild(doc.createTextNode(entity.getName()));
                staff.appendChild(entity_name);
                Element category = doc.createElement("category");
                category.appendChild(doc.createTextNode(entity.getCategoryName()));
                staff.appendChild(category);
                Set<String> matchingURIs = entity.getMatchingURIs();
                int j = 1;
                Element URIs = doc.createElement("URIs");
                if (!matchingURIs.isEmpty()) {
                    for (String tmp : matchingURIs) {
                        Element uri = doc.createElement("uri");
                        uri.appendChild(doc.createTextNode(tmp));
                        Attr attr2 = doc.createAttribute("id");
                        attr2.setValue(Integer.toString(j++));
                        uri.setAttributeNode(attr2);
                        URIs.appendChild(uri);
                    }
                }
                staff.appendChild(URIs);
                Element rank = doc.createElement("rank");
                rank.appendChild(doc.createTextNode(Double.toString(entity.getRank())));
                staff.appendChild(rank);
                Element num = doc.createElement("number_of_occurrences");
                num.appendChild(doc.createTextNode(Integer.toString(entity.getNumOfOccurrences())));
                staff.appendChild(num);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(this.filepath));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            Logger.getLogger(XMLExporter.class.getName()).log(Level.SEVERE, null, pce);
        }
        catch (TransformerException tfe) {
            Logger.getLogger(XMLExporter.class.getName()).log(Level.SEVERE, null, tfe);
        }
    }
}

