/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.textextractor;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.textextractor.TextExtractor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDFTextExtractor
implements TextExtractor {
    private String filepath;

    public PDFTextExtractor(String filepath) throws FalseFileTypeException {
        this.filepath = filepath;
        if (!filepath.endsWith("pdf")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    public String extractText() {
        String text = "";
        try {
            PdfReader reader = new PdfReader(this.filepath);
            int n = reader.getNumberOfPages();
            for (int i = 1; i <= n; ++i) {
                text = text + PdfTextExtractor.getTextFromPage((PdfReader)reader, (int)i) + "\n";
            }
            reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return text;
    }
}

