/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.textextractor;

import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.textextractor.PDFTextExtractor;
import gr.forth.ics.isl.xlink.textextractor.TextExtractor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;

public class PowerPointTextExtractor
implements TextExtractor {
    private String filepath;

    public PowerPointTextExtractor(String filepath) throws FalseFileTypeException {
        this.filepath = filepath;
        if (!filepath.toLowerCase().endsWith("pptx") || !filepath.toLowerCase().endsWith("ppt")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    public String extractText() {
        String text = this.filepath.toLowerCase().endsWith("pptx") ? this.extractText_pptx() : this.extractText_ppt();
        return text;
    }

    private String extractText_pptx() {
        String text = "";
        try {
            OPCPackage pkg = OPCPackage.open((String)this.filepath);
            XSLFSlideShow xmlA = new XSLFSlideShow(pkg);
            XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(xmlA);
            text = extractor.getText();
        }
        catch (IOException e) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception ex) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return text;
    }

    private String extractText_ppt() {
        String text = "";
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.filepath));
            PowerPointExtractor extractor = new PowerPointExtractor(fs);
            text = extractor.getText();
        }
        catch (IOException e) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception ex) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return text;
    }
}

