/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.textextractor;

import gr.forth.ics.isl.xlink.exceptions.FalseFileTypeException;
import gr.forth.ics.isl.xlink.textextractor.PDFTextExtractor;
import gr.forth.ics.isl.xlink.textextractor.TextExtractor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class WordTextExtractor
implements TextExtractor {
    private String filepath;

    public WordTextExtractor(String filepath) throws FalseFileTypeException {
        this.filepath = filepath;
        if (!filepath.toLowerCase().endsWith("docx") || !filepath.toLowerCase().endsWith("doc")) {
            throw new FalseFileTypeException(filepath);
        }
    }

    public String extractText() {
        String text = this.filepath.toLowerCase().endsWith("docx") ? this.extractText_docx() : this.extractText_doc();
        return text;
    }

    private String extractText_docx() {
        String text = "";
        try {
            FileInputStream fs = new FileInputStream(this.filepath);
            XWPFDocument hdoc = new XWPFDocument(OPCPackage.open((InputStream)fs));
            XWPFWordExtractor extractor = new XWPFWordExtractor(hdoc);
            text = extractor.getText();
        }
        catch (IOException e) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception ex) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return text;
    }

    private String extractText_doc() {
        String text = "";
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.filepath));
            HWPFDocument hdoc = new HWPFDocument(fs);
            WordExtractor extractor = new WordExtractor(hdoc);
            text = extractor.getText();
        }
        catch (IOException e) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception ex) {
            Logger.getLogger(PDFTextExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return text;
    }
}

