/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xlink.util;

import gr.forth.ics.isl.xlink.util.HTMLTag;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String readTemplateQuery(String templatePath) {
        String templ = "";
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templatePath), "UTF8"));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                templ = templ + line + " ";
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return templ;
    }

    public static String runSparqlQuery(String sparqlQueryPath) {
        String result = "";
        System.out.println("# SPARQL Query Path: " + sparqlQueryPath);
        URL url = null;
        try {
            String input;
            url = new URL(sparqlQueryPath);
            URLConnection con = null;
            con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            String xml_content = "application/sparql-results+xml";
            con.setRequestProperty("ACCEPT", xml_content);
            InputStream is = null;
            is = con.getInputStream();
            InputStreamReader isr = null;
            isr = new InputStreamReader(is, "utf8");
            BufferedReader in = new BufferedReader(isr);
            while ((input = in.readLine()) != null) {
                result = result + input + "\n";
            }
            in.close();
            isr.close();
            is.close();
        }
        catch (Exception ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("# SPARQL query was executed successfully!");
        return result;
    }

    public static TreeSet<String> readEntriesFromXmlResult(String xmlResultsString) {
        HTMLTag tagger = new HTMLTag(xmlResultsString);
        String headStr = tagger.getFirstTagData("head");
        String resultsStr = tagger.getFirstTagData("results");
        ArrayList<String> resultsVariables = new ArrayList<String>();
        HTMLTag headTagger = new HTMLTag(headStr);
        int i = headTagger.getFirstTagIndex("variable");
        while (i != -1) {
            String variableCont = headTagger.getFirstTagContent("variable", i);
            String variable = HTMLTag.getContentAttribute("name", variableCont);
            resultsVariables.add(variable);
            i = headTagger.getFirstTagIndex("variable", i + 1);
        }
        TreeSet<String> uris = new TreeSet<String>();
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        i = resultsTagger.getFirstTagIndex("result");
        while (i != -1) {
            String resultData = resultsTagger.getFirstTagData("result", i);
            HTMLTag resTagger = new HTMLTag(resultData);
            for (String variable : resultsVariables) {
                String bindingData = resTagger.getFirstTagDataContains("binding", "\"" + variable + "\"");
                if (bindingData == null) {
                    bindingData = resTagger.getFirstTagDataContains("binding", "'" + variable + "'");
                }
                if (bindingData == null) continue;
                bindingData = HTMLTag.removeTags(bindingData).trim();
                uris.add(bindingData);
            }
            i = resultsTagger.getFirstTagIndex("result", i + 1);
        }
        return uris;
    }
}

