/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.CollocationRegistry;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.NodeAssignmentPolicy;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import java.util.Collections;
import java.util.List;

public class MaximumCollocationPolicy
implements NodeAssignmentPolicy {
    public static float DefaultPenalty = 0.0f;
    private NodeSelector selector = null;
    private CollocationRegistry registry = new CollocationRegistry();
    private float threshold = 0.0f;
    private float collocationPenalty;

    public MaximumCollocationPolicy(NodeSelector selector) {
        this.selector = selector;
    }

    public MaximumCollocationPolicy(NodeSelector selector, float threshold) {
        this.selector = selector;
        this.threshold = threshold;
    }

    @Override
    public NodeAssignmentPolicy.Type getType() {
        return NodeAssignmentPolicy.Type.MaximumCollocation;
    }

    @Override
    public void setPenalty(float collocationPenalty) {
        this.collocationPenalty = collocationPenalty;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) throws Exception {
        List<HostingNodeInfo> assessed = this.selector.assessNodes(candidates);
        int minRound = Integer.MAX_VALUE;
        for (HostingNodeInfo hn : assessed) {
            int currRound = this.registry.currentRound(hn.node);
            if (currRound >= minRound) continue;
            minRound = currRound;
        }
        for (HostingNodeInfo hn : assessed) {
            if (!this.registry.isSelected(hn.node) || this.registry.currentRound(hn.node) != minRound || !(hn.score.floatValue() + this.registry.getCollocationScore(hn.node) > this.threshold)) continue;
            if ((double)this.collocationPenalty > 1.0E-10 || (double)this.collocationPenalty < -1.0E-10) {
                this.registry.addToCollocationScore(hn.node, -this.collocationPenalty);
            }
            this.selector.markSelected(hn.node);
            if (hn.score.floatValue() + this.registry.getCollocationScore(hn.node) <= this.threshold) {
                this.registry.newRound(hn.node);
            }
            return hn.node;
        }
        minRound = Integer.MAX_VALUE;
        HostingNode selected = null;
        for (HostingNodeInfo hn : assessed) {
            int currRound = this.registry.currentRound(hn.node);
            if (currRound >= minRound || !(hn.score.floatValue() > this.threshold)) continue;
            minRound = currRound;
            selected = hn.node;
        }
        if (selected == null) {
            throw new Exception("No nodes satisfying conditions were found during first round...check threshold (" + this.threshold + ")" + " vs penalty (" + this.collocationPenalty + ")");
        }
        this.registry.markSelected(selected);
        if ((double)this.collocationPenalty > 1.0E-10 || (double)this.collocationPenalty < -1.0E-10) {
            this.registry.addToCollocationScore(selected, -this.collocationPenalty);
        }
        this.selector.markSelected(selected);
        return selected;
    }

    public float getCommitFactor(HostingNode hn) throws Exception {
        List<HostingNodeInfo> assessed = this.selector.assessNodes(Collections.singletonList(hn));
        return this.registry.getTotalCollocationScore(hn) / (assessed.get((int)0).score.floatValue() - this.threshold);
    }

    @Override
    public void reset() {
        this.registry = new CollocationRegistry();
    }
}

