/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.ru;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RUNodeSelector
implements NodeSelector {
    protected static Map<String, Long> timingInfo = new ConcurrentHashMap<String, Long>();
    protected NodeSelector tieBreakerSelector = null;

    public RUNodeSelector() {
    }

    public RUNodeSelector(NodeSelector tieBreaker) {
        this.tieBreakerSelector = tieBreaker;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) {
        boolean firstRound = false;
        if (this.tieBreakerSelector != null) {
            for (HostingNode c : candidates) {
                if (timingInfo.containsKey(c.getId())) continue;
                firstRound = true;
            }
        }
        HostingNode RUNode = null;
        if (candidates.isEmpty()) {
            return null;
        }
        RUNode = firstRound ? this.tieBreakerSelector.selectNode(candidates) : this.getRUNode(candidates);
        timingInfo.put(RUNode.getId(), Calendar.getInstance().getTimeInMillis());
        return RUNode;
    }

    public abstract HostingNode getRUNode(List<HostingNode> var1);

    public abstract Map<String, Long> sortTimingInfo();

    @Override
    public List<HostingNodeInfo> assessNodes(List<HostingNode> candidates) {
        ArrayList<HostingNodeInfo> assessedNodes;
        block12: {
            HashMap<String, HostingNode> hnIndex;
            Map<String, Long> sortedTimingInfo;
            block10: {
                ArrayList<HostingNode> unselectedNodes;
                block11: {
                    sortedTimingInfo = this.sortTimingInfo();
                    sortedTimingInfo.putAll(timingInfo);
                    Float firstRoundMinScore = Float.valueOf(Float.MAX_VALUE);
                    assessedNodes = new ArrayList<HostingNodeInfo>();
                    unselectedNodes = new ArrayList<HostingNode>();
                    List<HostingNodeInfo> firstRoundAssessed = null;
                    int foundUnselected = 0;
                    for (HostingNode hn : candidates) {
                        if (timingInfo.containsKey(hn.getId())) continue;
                        if (firstRoundAssessed == null && this.tieBreakerSelector != null) {
                            firstRoundAssessed = this.tieBreakerSelector.assessNodes(candidates);
                            firstRoundMinScore = firstRoundAssessed.get((int)(firstRoundAssessed.size() - 1)).score;
                        }
                        ++foundUnselected;
                        unselectedNodes.add(hn);
                    }
                    hnIndex = new HashMap<String, HostingNode>();
                    for (HostingNode hn : candidates) {
                        hnIndex.put(hn.getId(), hn);
                    }
                    if (foundUnselected <= 0) break block10;
                    if (this.tieBreakerSelector == null) break block11;
                    for (HostingNodeInfo fra : firstRoundAssessed) {
                        if (timingInfo.containsKey(fra.node.getId())) continue;
                        assessedNodes.add(new HostingNodeInfo(fra.node, fra.score));
                    }
                    if ((double)Math.abs(((HostingNodeInfo)assessedNodes.get((int)0)).score.floatValue() - 1.0f) > 1.0E-10) {
                        float factor = 1.0f / ((HostingNodeInfo)assessedNodes.get((int)0)).score.floatValue();
                        Iterator<String> i$ = assessedNodes.iterator();
                        while (i$.hasNext()) {
                            HostingNodeInfo hn;
                            HostingNodeInfo hostingNodeInfo = hn = (HostingNodeInfo)((Object)i$.next());
                            Float.valueOf(hostingNodeInfo.score.floatValue() * factor);
                            hostingNodeInfo.score = hostingNodeInfo.score;
                        }
                        firstRoundMinScore = Float.valueOf(firstRoundMinScore.floatValue() * factor);
                    }
                    if (foundUnselected >= candidates.size()) break block12;
                    int j = 0;
                    float step = firstRoundMinScore.floatValue() / (float)(candidates.size() - foundUnselected + 1);
                    for (String hnId : sortedTimingInfo.keySet()) {
                        HostingNode hn = (HostingNode)hnIndex.get(hnId);
                        if (hn == null) continue;
                        assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(firstRoundMinScore.floatValue() - (float)(++j) * step)));
                    }
                    break block12;
                }
                for (HostingNode hn : unselectedNodes) {
                    assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(1.0f)));
                }
                int i = 1;
                for (String hnId : sortedTimingInfo.keySet()) {
                    HostingNode hn = (HostingNode)hnIndex.get(hnId);
                    if (hn == null) continue;
                    assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(1.0f - (float)i++ * (1.0f / (float)candidates.size()))));
                }
                break block12;
            }
            int i = 0;
            for (String hnId : sortedTimingInfo.keySet()) {
                HostingNode hn = (HostingNode)hnIndex.get(hnId);
                if (hn == null) continue;
                assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(1.0f - (float)i++ * (1.0f / (float)candidates.size()))));
            }
        }
        return assessedNodes;
    }

    @Override
    public void markSelected(HostingNode node) {
        timingInfo.put(node.getId(), Calendar.getInstance().getTimeInMillis());
    }

    public static void main(String[] args) {
    }
}

