/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.exception;

import gr.uoa.di.madgik.grs.record.exception.GRS2ThrowableWrapperException;
import java.io.Serializable;
import java.lang.reflect.Field;

public class GRS2ThrowableWrapper
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String className;
    private Throwable cause;
    private GRS2ThrowableWrapper causeWrap = this;

    public static Throwable convertToGenaralException(Throwable th) throws GRS2ThrowableWrapperException {
        return GRS2ThrowableWrapper.convertToException(Throwable.class, th);
    }

    public static Throwable convertToException(Class<?> exClass, Throwable th) throws GRS2ThrowableWrapperException {
        Throwable grs2Ex = null;
        try {
            grs2Ex = (Throwable)exClass.newInstance();
            grs2Ex.setStackTrace(th.getStackTrace());
            Class<Throwable> cl = Throwable.class;
            Field msgField = GRS2ThrowableWrapper.getField(cl, "detailMessage");
            msgField.setAccessible(true);
            String msg = (String)msgField.get(th);
            msgField.set(grs2Ex, msg);
            Field csField = GRS2ThrowableWrapper.getField(cl, "cause");
            csField.setAccessible(true);
            Throwable cause = (Throwable)csField.get(th);
            csField.set(grs2Ex, cause);
        }
        catch (Exception e) {
            throw new GRS2ThrowableWrapperException("error converting exception to " + exClass.getCanonicalName(), e);
        }
        return grs2Ex;
    }

    public static GRS2ThrowableWrapper createFromThrowable(Throwable th) throws GRS2ThrowableWrapperException {
        GRS2ThrowableWrapper tw = new GRS2ThrowableWrapper();
        tw.className = th.getClass().getName();
        Throwable grs2Ex = null;
        try {
            grs2Ex = GRS2ThrowableWrapper.convertToGenaralException(th);
        }
        catch (Exception e) {
            throw new GRS2ThrowableWrapperException("Could not instantiate " + Throwable.class + " object", e);
        }
        tw.cause = grs2Ex;
        Class<Throwable> cl = Throwable.class;
        try {
            Field csField = GRS2ThrowableWrapper.getField(cl, "cause");
            csField.setAccessible(true);
            Throwable cause = (Throwable)csField.get(th);
            tw.causeWrap = !cause.equals(th) ? GRS2ThrowableWrapper.createFromThrowable(cause) : null;
        }
        catch (Exception e) {
            throw new GRS2ThrowableWrapperException("error creating throwable wrapper from throwable", e);
        }
        return tw;
    }

    public static Throwable createFromGRS2ThrowableWrapper(GRS2ThrowableWrapper tw, Class<?> genericException) throws GRS2ThrowableWrapperException {
        Class<?> cl = null;
        Throwable grs2Exception = null;
        try {
            cl = Class.forName(tw.className);
            grs2Exception = (Throwable)cl.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            cl = genericException;
            try {
                grs2Exception = (Throwable)cl.newInstance();
            }
            catch (Exception ex) {
                throw new GRS2ThrowableWrapperException("Could not instantiate " + cl + " object", ex);
            }
        }
        grs2Exception.setStackTrace(tw.cause.getStackTrace());
        try {
            Field fdm = GRS2ThrowableWrapper.getField(cl, "detailMessage");
            fdm.setAccessible(true);
            fdm.set(grs2Exception, fdm.get(tw.cause));
            Field fcause = GRS2ThrowableWrapper.getField(cl, "cause");
            fcause.setAccessible(true);
            Throwable cause = (Throwable)fcause.get(tw.cause);
            if (cause != null && !cause.equals(tw.cause)) {
                if (tw.causeWrap != null) {
                    cause = GRS2ThrowableWrapper.createFromGRS2ThrowableWrapper(tw.causeWrap, genericException);
                    fcause.set(grs2Exception, cause);
                }
            } else {
                fcause.set(grs2Exception, cause);
            }
        }
        catch (Exception e) {
            throw new GRS2ThrowableWrapperException("error creating throwable from wrapper", e);
        }
        return grs2Exception;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return GRS2ThrowableWrapper.getField(superClass, fieldName);
        }
    }
}

