/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.fishgrowth.Simulator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.i2s.fishgrowth.Simulator.b;
import gr.i2s.fishgrowth.Simulator.c;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.Sfr;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class Executor {
    private static final Log a = LogFactoryUtil.getLog(Executor.class);
    protected static final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("YYYYMMdd-Hms-S");
    protected Ordering<Fcr> fcrByTempWeight = new gr.i2s.fishgrowth.Simulator.a(this);
    protected Ordering<Sfr> sfrByTempWeight = new b(this);
    protected Ordering<Mortality> mortalityByTempWeight = new c(this);
    protected final Scenario mScenario;
    protected final Map<Integer, RangeMap<Double, Double>> fcrTable;
    protected final Map<Integer, RangeMap<Double, Double>> sfrTable;
    protected final Map<Integer, RangeMap<Double, Double>> mortalityTable;
    protected final Map<Long, Integer> temperatureTable;
    protected final Integer[] modelTemperature;
    protected final Queue<a> dailyResults;

    public Executor(Scenario scenario) {
        this.mScenario = scenario;
        this.fcrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.sfrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.mortalityTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.temperatureTable = new HashMap<Long, Integer>();
        this.modelTemperature = new Integer[24];
        this.dailyResults = new LinkedList<a>();
    }

    public void run() {
        this.beforeRun();
        this.a();
        this.afterRun();
    }

    protected void beforeRun() {
    }

    protected void afterRun() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mScenario", (Object)this.mScenario).add("fcrTable", this.fcrTable).add("sfrTable", this.sfrTable).add("mortalityTable", this.mortalityTable).add("temperatureTable", this.temperatureTable).add("modelTemperature", (Object)Arrays.deepToString(new Object[]{this.modelTemperature})).add("dailyResults", (Object)Arrays.deepToString(new Object[]{this.dailyResults})).toString();
    }

    private void a() {
        Object object;
        Object object2;
        Object object3;
        Double d;
        Double d2;
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.mScenario.getStartDate());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.mScenario.getTargetDate());
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        double d3 = this.mScenario.getWeight() * (double)this.mScenario.getFishNo();
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        if (a.isTraceEnabled()) {
            a.trace((Object)String.format("temperatureTable %s", this.temperatureTable));
        }
        if (a.isTraceEnabled()) {
            a.trace((Object)String.format("sfrTable %s", this.sfrTable));
        }
        if (a.isTraceEnabled()) {
            a.trace((Object)String.format("fcrTable %s", this.fcrTable));
        }
        a a2 = new a();
        a2.c = this.mScenario.getWeight();
        a2.d = this.mScenario.getFishNo();
        Calendar calendar3 = calendar;
        while (!calendar3.after(calendar2)) {
            double d6;
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("on day [%s] as millis [%s]", FULL_DATE_FORMAT.format(calendar3.getTime()), calendar3.getTimeInMillis()));
            }
            a2.a.setTimeInMillis(calendar3.getTimeInMillis());
            a2.e = 0;
            a2.g = 0.0;
            a2.h = 0.0;
            Integer n2 = this.temperatureTable.get(a2.a.getTimeInMillis());
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("temperature %s", n2));
            }
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("sfr temperature [%s] selection %s", n2, this.sfrTable.get(n2)));
            }
            a2.b = n2;
            d2 = (Double)this.sfrTable.get(n2).get((Comparable)a2.c);
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("sfr on mab [%s] selection %s", a2.c, d2));
            }
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("fcr temperature [%s] selection %s", n2, this.fcrTable.get(n2)));
            }
            a2.j = d2 * 100.0;
            d = (Double)this.fcrTable.get(n2).get((Comparable)a2.c);
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("fcr on mab [%s] selection %s", a2.c, d));
            }
            a2.i = d * 100.0;
            a2.e = (int)((Double)this.mortalityTable.get(n2).get((Comparable)a2.c) * (double)a2.d.intValue());
            a2.f = (double)a2.e.intValue() * a2.c;
            n += a2.e.intValue();
            d5 += a2.f.doubleValue();
            a a3 = a2;
            Integer.valueOf(a3.d - a2.e);
            a3.d = a3.d;
            a2.g = a2.c * (double)a2.d.intValue() * d2;
            d4 += a2.g.doubleValue();
            double d7 = a2.g / (double)a2.d.intValue();
            a2.h = d > 0.0 ? d7 / (d * 100.0) : 0.0;
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("adding daily [%s]", a2));
            }
            a2.l = (Double)(object3 = Double.valueOf((d6 = a2.c * (double)a2.d.intValue()) - d3)) > 0.0 ? d4 / (Double)object3 : 0.0;
            object3 = (Double)object3 - d5;
            a2.k = (Double)object3 > 0.0 ? d4 / (Double)object3 : 0.0;
            this.dailyResults.add(a2);
            object2 = a2;
            a2 = new a((a)object2);
            object = a2;
            Double.valueOf(((a)object).c + ((a)object2).h);
            ((a)object).c = ((a)object).c;
            if (a.isTraceEnabled()) {
                a.trace((Object)String.format("prevDay [%s] curDay [%s]", object2, a2));
            }
            object2 = null;
            calendar3.add(5, 1);
        }
        if (a.isDebugEnabled()) {
            a.debug((Object)String.format("final day [%s]", a2));
        }
        if (a.isTraceEnabled()) {
            a.trace((Object)String.format("detailed daily results [%s]", this.dailyResults));
        }
        double d8 = a2.c * (double)a2.d.intValue();
        this.mScenario.setResultsWeight(a2.c);
        d2 = d8 - d3;
        this.mScenario.setResultsEconFCR(d2 > 0.0 ? d4 / d2 : 0.0);
        d = d2 - d5;
        this.mScenario.setResultsBiolFCR(d > 0.0 ? d4 / d : 0.0);
        this.mScenario.setResultsMortality(100.0 * ((double)n / (double)this.mScenario.getFishNo()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        object3 = "{c:[{v: '%s'}, {v: %.2f}]},";
        object2 = "{c:[{v: '%s'}, {v: %.2f}, {v: %.2f}]},";
        object = "{c:[{v: '%s-%s'}, {v: %.2f}]},";
        int n3 = -1;
        int n4 = -1;
        double d9 = 0.0;
        for (a a4 : this.dailyResults) {
            String string4 = simpleDateFormat.format(a4.a.getTime());
            string = string + String.format((String)object3, string4, a4.c);
            if (a4.k > 0.0) {
                string2 = string2 + String.format((String)object2, string4, a4.k, a4.l);
            }
            if (n3 != a4.a.get(2) || n4 != a4.a.get(1)) {
                if (d9 > 0.0) {
                    string3 = string3 + String.format((String)object, n3 + 1, n4, d9 / 1000.0);
                }
                d9 = 0.0;
                n3 = a4.a.get(2);
                n4 = a4.a.get(1);
            }
            d9 += a2.g.doubleValue();
        }
        if (d9 > 0.0) {
            string3 = string3 + String.format((String)object, n3 + 1, n4, d9 / 1000.0);
        }
        this.mScenario.setResultsGraphData(string + "gri2sbbridge" + string2 + "gri2sbbridge" + string3);
        long l2 = System.currentTimeMillis() - l;
        if (a.isDebugEnabled()) {
            a.debug((Object)String.format("actual run took [%s] ms", l2));
        }
        if (a.isDebugEnabled()) {
            a.debug((Object)String.format("results [%s]", this.mScenario));
        }
    }

    class a {
        public Calendar a = Calendar.getInstance();
        public Integer b;
        public Double c;
        public Integer d;
        public Integer e;
        public Double f;
        public Double g;
        public Double h;
        public Double i;
        public Double j;
        public Double k;
        public Double l;

        public a(a a2) {
            this();
            this.a.setTime(new Date(a2.a.getTimeInMillis()));
            this.b = new Integer(a2.b);
            this.c = new Double(a2.c);
            this.d = new Integer(a2.d);
            this.e = new Integer(a2.e);
            this.f = new Double(a2.f);
            this.g = new Double(a2.g);
            this.h = new Double(a2.h);
            this.i = new Double(a2.i);
            this.j = new Double(a2.j);
            this.k = new Double(a2.k);
            this.l = new Double(a2.l);
        }

        public a() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)FULL_DATE_FORMAT.format(this.a.getTime())).add("temperature", (Object)this.b).add("mab", (Object)this.c).add("fishcount", (Object)this.d).add("dead", (Object)this.e).add("deadBM", (Object)this.f).add("food", (Object)this.g).add("growth", (Object)this.h).add("fcr", (Object)this.i).add("sfr", (Object)this.j).add("fcrBiol", (Object)this.k).add("fcrEcon", (Object)this.l).toString();
        }
    }
}

