/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.fishgrowth.Simulator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.i2s.fishgrowth.Simulator.a;
import gr.i2s.fishgrowth.Simulator.b;
import gr.i2s.fishgrowth.Simulator.c;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.Sfr;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class Executor {
    private static final Log b = LogFactoryUtil.getLog(Executor.class);
    protected final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("YYYYMMdd-Hms-S");
    protected Ordering<Fcr> fcrByTempWeight = new a(this);
    protected Ordering<Sfr> sfrByTempWeight = new b(this);
    protected Ordering<Mortality> mortalityByTempWeight = new c(this);
    protected final Scenario mScenario;
    protected final Map<Integer, RangeMap<Double, Double>> fcrTable;
    protected final Map<Integer, RangeMap<Double, Double>> sfrTable;
    protected final Map<Integer, RangeMap<Double, Double>> mortalityTable;
    protected final Map<Long, Integer> temperatureTable;
    protected final Integer[] modelTemperature;
    protected final Queue<Daily> dailyResults;
    final List<ProcessDaiyDataListener> a = new ArrayList<ProcessDaiyDataListener>();

    public Executor(Scenario scenario) {
        this.mScenario = scenario;
        this.fcrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.sfrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.mortalityTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.temperatureTable = new HashMap<Long, Integer>();
        this.modelTemperature = new Integer[24];
        this.dailyResults = new LinkedList<Daily>();
    }

    public void run() {
        this.beforeRun();
        this.a();
        this.afterRun();
    }

    protected void beforeRun() {
    }

    protected void afterRun() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mScenario", (Object)this.mScenario).add("fcrTable", this.fcrTable).add("sfrTable", this.sfrTable).add("mortalityTable", this.mortalityTable).add("temperatureTable", this.temperatureTable).add("modelTemperature", (Object)Arrays.deepToString(new Object[]{this.modelTemperature})).add("dailyResults", (Object)Arrays.deepToString(new Object[]{this.dailyResults})).toString();
    }

    private void a() {
        Object object;
        Object object2;
        Object object3;
        Double d;
        Double d2;
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.mScenario.getStartDate());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.mScenario.getTargetDate());
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        double d3 = this.mScenario.getWeight() * (double)this.mScenario.getFishNo();
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        if (b.isTraceEnabled()) {
            b.trace((Object)String.format("temperatureTable %s", this.temperatureTable));
        }
        if (b.isTraceEnabled()) {
            b.trace((Object)String.format("sfrTable %s", this.sfrTable));
        }
        if (b.isTraceEnabled()) {
            b.trace((Object)String.format("fcrTable %s", this.fcrTable));
        }
        Daily daily = new Daily();
        daily.mab = this.mScenario.getWeight();
        daily.fishcount = this.mScenario.getFishNo();
        Calendar calendar3 = calendar;
        while (!calendar3.after(calendar2)) {
            double d6;
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("on day [%s] as millis [%s]", this.FULL_DATE_FORMAT.format(calendar3.getTime()), calendar3.getTimeInMillis()));
            }
            daily.date.setTimeInMillis(calendar3.getTimeInMillis());
            daily.dead = 0;
            daily.food = 0.0;
            daily.growth = 0.0;
            Integer n2 = this.temperatureTable.get(daily.date.getTimeInMillis());
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("temperature %s", n2));
            }
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("sfr temperature [%s] selection %s", n2, this.sfrTable.get(n2)));
            }
            daily.temperature = n2;
            d2 = (Double)this.sfrTable.get(n2).get((Comparable)daily.mab);
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("sfr on mab [%s] selection %s", daily.mab, d2));
            }
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("fcr temperature [%s] selection %s", n2, this.fcrTable.get(n2)));
            }
            daily.sfr = d2 * 100.0;
            d = (Double)this.fcrTable.get(n2).get((Comparable)daily.mab);
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("fcr on mab [%s] selection %s", daily.mab, d));
            }
            daily.fcr = d * 100.0;
            daily.dead = (int)((Double)this.mortalityTable.get(n2).get((Comparable)daily.mab) * (double)daily.fishcount.intValue());
            daily.deadBM = (double)daily.dead.intValue() * daily.mab;
            n += daily.dead.intValue();
            d5 += daily.deadBM.doubleValue();
            Daily daily2 = daily;
            Integer.valueOf(daily2.fishcount - daily.dead);
            daily2.fishcount = daily2.fishcount;
            daily.food = daily.mab * (double)daily.fishcount.intValue() * d2;
            d4 += daily.food.doubleValue();
            double d7 = daily.food / (double)daily.fishcount.intValue();
            daily.growth = d > 0.0 ? d7 / (d * 100.0) : 0.0;
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("adding daily [%s]", daily));
            }
            daily.fcrEcon = (Double)(object3 = Double.valueOf((d6 = daily.mab * (double)daily.fishcount.intValue()) - d3)) > 0.0 ? d4 / (Double)object3 : 0.0;
            object3 = (Double)object3 - d5;
            daily.fcrBiol = (Double)object3 > 0.0 ? d4 / (Double)object3 : 0.0;
            this.dailyResults.add(daily);
            object2 = daily;
            daily = new Daily((Daily)object2);
            object = daily;
            Double.valueOf(((Daily)object).mab + ((Daily)object2).growth);
            ((Daily)object).mab = ((Daily)object).mab;
            if (b.isTraceEnabled()) {
                b.trace((Object)String.format("prevDay [%s] curDay [%s]", object2, daily));
            }
            object2 = null;
            calendar3.add(5, 1);
        }
        if (b.isDebugEnabled()) {
            b.debug((Object)String.format("final day [%s]", daily));
        }
        if (b.isTraceEnabled()) {
            b.trace((Object)String.format("detailed daily results [%s]", this.dailyResults));
        }
        double d8 = daily.mab * (double)daily.fishcount.intValue();
        this.mScenario.setResultsWeight(daily.mab);
        d2 = d8 - d3;
        this.mScenario.setResultsEconFCR(d2 > 0.0 ? d4 / d2 : 0.0);
        d = d2 - d5;
        this.mScenario.setResultsBiolFCR(d > 0.0 ? d4 / d : 0.0);
        this.mScenario.setResultsMortality(100.0 * ((double)n / (double)this.mScenario.getFishNo()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        object3 = "{c:[{v: '%s'}, {v: %.2f}]},";
        object2 = "{c:[{v: '%s'}, {v: %.2f}, {v: %.2f}]},";
        object = "{c:[{v: '%s-%s'}, {v: %.2f}]},";
        int n3 = -1;
        int n4 = -1;
        double d9 = 0.0;
        for (Daily object4 : this.dailyResults) {
            String string4 = simpleDateFormat.format(object4.date.getTime());
            string = string + String.format((String)object3, string4, object4.mab);
            if (object4.fcrBiol > 0.0) {
                string2 = string2 + String.format((String)object2, string4, object4.fcrBiol, object4.fcrEcon);
            }
            if (n3 != object4.date.get(2) || n4 != object4.date.get(1)) {
                if (d9 > 0.0) {
                    string3 = string3 + String.format((String)object, n3 + 1, n4, d9 / 1000.0);
                }
                d9 = 0.0;
                n3 = object4.date.get(2);
                n4 = object4.date.get(1);
            }
            d9 += daily.food.doubleValue();
        }
        if (d9 > 0.0) {
            string3 = string3 + String.format((String)object, n3 + 1, n4, d9 / 1000.0);
        }
        for (ProcessDaiyDataListener processDaiyDataListener : this.a) {
            processDaiyDataListener.getForProcessing(this.dailyResults);
        }
        this.mScenario.setResultsGraphData(string + "gri2sbbridge" + string2 + "gri2sbbridge" + string3);
        long l2 = System.currentTimeMillis() - l;
        if (b.isDebugEnabled()) {
            b.debug((Object)String.format("actual run took [%s] ms", l2));
        }
        if (b.isDebugEnabled()) {
            b.debug((Object)String.format("results [%s]", this.mScenario));
        }
    }

    public void addProcessDaiyDataListener(ProcessDaiyDataListener listener) {
        this.a.add(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProcessDaiyDataListener {
        public void getForProcessing(Queue<Daily> var1);
    }

    public class Daily {
        public Calendar date = Calendar.getInstance();
        public Integer temperature;
        public Double mab;
        public Integer fishcount;
        public Integer dead;
        public Double deadBM;
        public Double food;
        public Double growth;
        public Double fcr;
        public Double sfr;
        public Double fcrBiol;
        public Double fcrEcon;

        public Daily(Daily daily) {
            this();
            this.date.setTime(new Date(daily.date.getTimeInMillis()));
            this.temperature = new Integer(daily.temperature);
            this.mab = new Double(daily.mab);
            this.fishcount = new Integer(daily.fishcount);
            this.dead = new Integer(daily.dead);
            this.deadBM = new Double(daily.deadBM);
            this.food = new Double(daily.food);
            this.growth = new Double(daily.growth);
            this.fcr = new Double(daily.fcr);
            this.sfr = new Double(daily.sfr);
            this.fcrBiol = new Double(daily.fcrBiol);
            this.fcrEcon = new Double(daily.fcrEcon);
        }

        public Daily() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)Executor.this.FULL_DATE_FORMAT.format(this.date.getTime())).add("temperature", (Object)this.temperature).add("mab", (Object)this.mab).add("fishcount", (Object)this.fishcount).add("dead", (Object)this.dead).add("deadBM", (Object)this.deadBM).add("food", (Object)this.food).add("growth", (Object)this.growth).add("fcr", (Object)this.fcr).add("sfr", (Object)this.sfr).add("fcrBiol", (Object)this.fcrBiol).add("fcrEcon", (Object)this.fcrEcon).toString();
        }
    }
}

