/*
 * Decompiled with CFR 0.152.
 */
package gr.i2s.fishgrowth.Simulator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeMap;
import gr.i2s.fishgrowth.Simulator.a;
import gr.i2s.fishgrowth.Simulator.b;
import gr.i2s.fishgrowth.Simulator.c;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.Sfr;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executor {
    private static final Logger a = LoggerFactory.getLogger(Executor.class);
    protected final SimpleDateFormat FULL_DATE_FORMAT = new SimpleDateFormat("YYYYMMdd-Hms-S");
    protected Ordering<Fcr> fcrByTempWeight = new a(this);
    protected Ordering<Sfr> sfrByTempWeight = new b(this);
    protected Ordering<Mortality> mortalityByTempWeight = new c(this);
    protected final Scenario mScenario;
    protected final Map<Integer, RangeMap<Double, Double>> fcrTable;
    protected final Map<Integer, RangeMap<Double, Double>> sfrTable;
    protected final Map<Integer, RangeMap<Double, Double>> mortalityTable;
    protected final Map<Long, Integer> temperatureTable;
    protected final Integer[] modelTemperature;
    protected final Queue<Daily> dailyResults;

    public Executor(Scenario scenario) {
        a.error("deleteme Executor ctor");
        System.out.println("deleteme Executor ctor");
        this.mScenario = scenario;
        this.fcrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.sfrTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.mortalityTable = new HashMap<Integer, RangeMap<Double, Double>>();
        this.temperatureTable = new HashMap<Long, Integer>();
        this.modelTemperature = new Integer[24];
        this.dailyResults = new LinkedList<Daily>();
        a.error("deleteme Executor ctor done");
        System.out.println("deleteme Executor ctor done");
    }

    public void run() {
        this.beforeRun();
        this.a();
        this.afterRun();
    }

    protected void beforeRun() {
    }

    protected void afterRun() {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mScenario", (Object)this.mScenario).add("fcrTable", this.fcrTable).add("sfrTable", this.sfrTable).add("mortalityTable", this.mortalityTable).add("temperatureTable", this.temperatureTable).add("modelTemperature", (Object)Arrays.deepToString(new Object[]{this.modelTemperature})).add("dailyResults", (Object)Arrays.deepToString(new Object[]{this.dailyResults})).toString();
    }

    private void a() {
        Object object;
        Double d;
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.mScenario.getStartDate());
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.mScenario.getTargetDate());
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        double d2 = this.mScenario.getWeight();
        double d3 = d2 * (double)this.mScenario.getFishNo();
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        if (a.isTraceEnabled()) {
            a.trace(String.format("temperatureTable %s", this.temperatureTable));
        }
        if (a.isTraceEnabled()) {
            a.trace(String.format("sfrTable %s", this.sfrTable));
        }
        if (a.isTraceEnabled()) {
            a.trace(String.format("fcrTable %s", this.fcrTable));
        }
        Daily daily = new Daily();
        daily.mab = d2;
        daily.fishcount = this.mScenario.getFishNo();
        int n2 = 0;
        Calendar calendar3 = calendar;
        while (!calendar3.after(calendar2)) {
            if (a.isTraceEnabled()) {
                a.trace(String.format("on day [%s] as millis [%s]", this.FULL_DATE_FORMAT.format(calendar3.getTime()), calendar3.getTimeInMillis()));
            }
            ++n2;
            try {
                daily.date.setTimeInMillis(calendar3.getTimeInMillis());
                daily.dead = 0;
                daily.food = 0.0;
                daily.growth = 0.0;
                Integer n3 = this.temperatureTable.get(daily.date.getTimeInMillis());
                if (a.isTraceEnabled()) {
                    a.trace(String.format("temperature %s", n3));
                }
                daily.temperature = n3;
                if (a.isTraceEnabled()) {
                    a.trace(String.format("sfr temperature [%s] selection %s", n3, this.sfrTable.get(n3)));
                }
                Double d6 = (Double)this.sfrTable.get(n3).get((Comparable)daily.mab);
                if (a.isTraceEnabled()) {
                    a.trace(String.format("sfr on mab [%s] selection %s", daily.mab, d6));
                }
                if (a.isTraceEnabled()) {
                    a.trace(String.format("fcr temperature [%s] selection %s", n3, this.fcrTable.get(n3)));
                }
                Double d7 = (Double)this.fcrTable.get(n3).get((Comparable)daily.mab);
                if (a.isTraceEnabled()) {
                    a.trace(String.format("fcr on mab [%s] selection %s", daily.mab, d7));
                }
                if (a.isTraceEnabled()) {
                    a.trace(String.format("mortality temperature [%s] selection %s", n3, this.mortalityTable.get(n3)));
                }
                d = (Double)this.mortalityTable.get(n3).get((Comparable)daily.mab) / 100.0;
                if (a.isTraceEnabled()) {
                    a.trace(String.format("mortality on mab [%s] selection %s", daily.mab, d));
                }
                daily.fcr = d7;
                daily.sfr = d6;
                daily.dead = (int)((double)daily.fishcount.intValue() * d);
                daily.deadBM = (double)daily.dead.intValue() * daily.mab;
                n += daily.dead.intValue();
                d5 += daily.deadBM.doubleValue();
                object = daily;
                Integer.valueOf(((Daily)object).fishcount - daily.dead);
                ((Daily)object).fishcount = ((Daily)object).fishcount;
                daily.food = daily.mab * (double)daily.fishcount.intValue() * daily.sfr / 100.0;
                d4 += daily.food.doubleValue();
                object = daily.food / (double)daily.fishcount.intValue();
                daily.growth = daily.fcr > 0.0 ? (Double)object / daily.fcr : 0.0;
                Double d8 = daily.mab * (double)daily.fishcount.intValue();
                Double d9 = d8 - d3;
                if (a.isTraceEnabled()) {
                    a.trace(String.format("dayBM [%s] dBM [%s]", d8, d9));
                }
                daily.fcrEcon = d9 > 0.0 ? d4 / d9 : 0.0;
                d9 = d9 - d5;
                daily.fcrBiol = d9 > 0.0 ? d4 / d9 : 0.0;
                if (a.isTraceEnabled()) {
                    a.trace(String.format("adding daily [%s]", daily));
                }
                this.dailyResults.add(daily);
                Daily daily2 = daily;
                Daily daily3 = daily = new Daily(daily2);
                Double.valueOf(daily3.mab + daily2.growth);
                daily3.mab = daily3.mab;
                if (a.isTraceEnabled()) {
                    a.trace(String.format("prevDay [%s] curDay [%s]", daily2, daily));
                }
                daily2 = null;
            }
            catch (Exception exception) {
                a.error(String.format("Prolem executing scenario [%s] on day [%s] ~ full contents [%s]", this.mScenario.getId(), calendar3.getTime(), this.mScenario), (Throwable)exception);
                throw new RuntimeException(String.format("Prolem executing scenario [%s] on day [%s]", this.mScenario.getId(), calendar3), exception);
            }
            calendar3.add(5, 1);
        }
        if (a.isDebugEnabled()) {
            a.debug(String.format("final day [%s]", daily));
        }
        if (a.isTraceEnabled()) {
            a.trace(String.format("detailed daily results [%s]", this.dailyResults));
        }
        double d10 = daily.mab;
        double d11 = d10 * (double)daily.fishcount.intValue();
        this.mScenario.setResultsWeight(d10);
        d = d11 - d3;
        this.mScenario.setResultsEconFCR(d > 0.0 ? d4 / d : 0.0);
        object = d - d5;
        this.mScenario.setResultsBiolFCR((Double)object > 0.0 ? d4 / (Double)object : 0.0);
        this.mScenario.setResultsMortality(100.0 * ((double)n / (double)this.mScenario.getFishNo()));
        this.mScenario.setResultsGrowth((d10 - d2) / (double)n2);
        this.mScenario.setResultsSGR(100.0 * (Math.log(d10) - Math.log(d2)) / (double)n2);
        this.mScenario.setResultsGraphData(this.processResults());
        long l2 = System.currentTimeMillis() - l;
        if (a.isDebugEnabled()) {
            a.debug(String.format("actual run took [%s] ms", l2));
        }
        if (a.isTraceEnabled()) {
            a.trace(String.format("results [%s]", this.mScenario));
        }
    }

    protected abstract String processResults();

    public class Daily {
        public Calendar date = Calendar.getInstance();
        public Integer temperature;
        public Double mab;
        public Integer fishcount;
        public Integer dead;
        public Double deadBM;
        public Double food;
        public Double growth;
        public Double fcr;
        public Double sfr;
        public Double fcrBiol;
        public Double fcrEcon;

        public Daily(Daily daily) {
            this();
            this.date.setTime(new Date(daily.date.getTimeInMillis()));
            this.temperature = new Integer(daily.temperature);
            this.mab = new Double(daily.mab);
            this.fishcount = new Integer(daily.fishcount);
            this.dead = new Integer(daily.dead);
            this.deadBM = new Double(daily.deadBM);
            this.food = new Double(daily.food);
            this.growth = new Double(daily.growth);
            this.fcr = new Double(daily.fcr);
            this.sfr = new Double(daily.sfr);
            this.fcrBiol = new Double(daily.fcrBiol);
            this.fcrEcon = new Double(daily.fcrEcon);
        }

        public Daily() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)Executor.this.FULL_DATE_FORMAT.format(this.date.getTime())).add("temperature", (Object)this.temperature).add("mab", (Object)this.mab).add("fishcount", (Object)this.fishcount).add("dead", (Object)this.dead).add("deadBM", (Object)this.deadBM).add("food", (Object)this.food).add("growth", (Object)this.growth).add("fcr", (Object)this.fcr).add("sfr", (Object)this.sfr).add("fcrBiol", (Object)this.fcrBiol).add("fcrEcon", (Object)this.fcrEcon).toString();
        }
    }
}

