/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JPanel;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gui.swing.HighlightManager;
import org.geotools.gui.swing.event.HighlightChangeListener;
import org.geotools.gui.swing.event.HighlightChangedEvent;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbolizer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JMapPane
extends JPanel
implements MouseListener,
HighlightChangeListener,
PropertyChangeListener {
    GTRenderer renderer;
    MapContext context;
    private MapContext selectionContext;
    Envelope mapArea;
    private Rectangle oldRect = null;
    private Envelope oldMapArea = null;
    private BufferedImage baseImage;
    private BufferedImage selectImage;
    private Style selectionStyle;
    private int selectionLayer = -1;
    private MapLayer highlightLayer;
    private HighlightManager highlightManager;
    private boolean highlight = true;
    FilterFactory ff = FilterFactoryFinder.createFilterFactory();
    GeometryFactory gf = new GeometryFactory();
    FeatureCollection selection;
    FeatureCollection highlightFeature;
    public static final int Reset = 0;
    public static final int ZoomIn = 1;
    public static final int ZoomOut = 2;
    public static final int Pan = 3;
    public static final int Select = 4;
    private int state = 1;
    private double zoomFactor = 2.0;
    Style lineHighlightStyle;
    Style pointHighlightStyle;
    Style polygonHighlightStyle;
    Style polygonSelectionStyle;
    Style pointSelectionStyle;
    Style lineSelectionStyle;
    private boolean reset = false;
    private static final int POLYGON = 0;
    private static final int LINE = 1;
    private static final int POINT = 2;

    public JMapPane() {
        this(null, true, null, null);
    }

    public JMapPane(GTRenderer render, MapContext context) {
        this(null, true, render, context);
    }

    public JMapPane(LayoutManager layout, boolean isDoubleBuffered, GTRenderer render, MapContext context) {
        super(layout, isDoubleBuffered);
        this.setRenderer(render);
        this.setContext(context);
        this.addMouseListener(this);
        this.setHighlightManager(new HighlightManager(this.highlightLayer));
        this.lineHighlightStyle = this.setupStyle(1, Color.red);
        this.pointHighlightStyle = this.setupStyle(2, Color.red);
        this.polygonHighlightStyle = this.setupStyle(0, Color.red);
        this.polygonSelectionStyle = this.setupStyle(0, Color.cyan);
        this.pointSelectionStyle = this.setupStyle(2, Color.cyan);
        this.lineSelectionStyle = this.setupStyle(1, Color.cyan);
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        this.renderer = renderer;
        if (this.context != null) {
            this.renderer.setContext(this.context);
        }
    }

    public MapContext getContext() {
        return this.context;
    }

    public void setContext(MapContext context) {
        this.context = context;
        if (this.renderer != null) {
            this.renderer.setContext(this.context);
        }
    }

    public Envelope getMapArea() {
        return this.mapArea;
    }

    public void setMapArea(Envelope mapArea) {
        this.mapArea = mapArea;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        System.out.println("State: " + state);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public int getSelectionLayer() {
        return this.selectionLayer;
    }

    public void setSelectionLayer(int selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public MapLayer getHighlightLayer() {
        return this.highlightLayer;
    }

    public void setHighlightLayer(MapLayer highlightLayer) {
        this.highlightLayer = highlightLayer;
        if (this.highlightManager != null) {
            this.highlightManager.setHighlightLayer(highlightLayer);
        }
    }

    public HighlightManager getHighlightManager() {
        return this.highlightManager;
    }

    public void setHighlightManager(HighlightManager highlightManager) {
        this.highlightManager = highlightManager;
        this.highlightManager.addHighlightChangeListener(this);
        this.addMouseMotionListener(this.highlightManager);
    }

    public Style getLineHighlightStyle() {
        return this.lineHighlightStyle;
    }

    public void setLineHighlightStyle(Style lineHighlightStyle) {
        this.lineHighlightStyle = lineHighlightStyle;
    }

    public Style getLineSelectionStyle() {
        return this.lineSelectionStyle;
    }

    public void setLineSelectionStyle(Style lineSelectionStyle) {
        this.lineSelectionStyle = lineSelectionStyle;
    }

    public Style getPointHighlightStyle() {
        return this.pointHighlightStyle;
    }

    public void setPointHighlightStyle(Style pointHighlightStyle) {
        this.pointHighlightStyle = pointHighlightStyle;
    }

    public Style getPointSelectionStyle() {
        return this.pointSelectionStyle;
    }

    public void setPointSelectionStyle(Style pointSelectionStyle) {
        this.pointSelectionStyle = pointSelectionStyle;
    }

    public Style getPolygonHighlightStyle() {
        return this.polygonHighlightStyle;
    }

    public void setPolygonHighlightStyle(Style polygonHighlightStyle) {
        this.polygonHighlightStyle = polygonHighlightStyle;
    }

    public Style getPolygonSelectionStyle() {
        return this.polygonSelectionStyle;
    }

    public void setPolygonSelectionStyle(Style polygonSelectionStyle) {
        this.polygonSelectionStyle = polygonSelectionStyle;
    }

    protected void paintComponent(Graphics g) {
        boolean changed = false;
        super.paintComponent(g);
        if (this.renderer == null || this.mapArea == null) {
            return;
        }
        Rectangle r = this.getBounds();
        Rectangle dr = new Rectangle(r.width, r.height);
        if (!r.equals(this.oldRect) || this.reset) {
            changed = true;
            this.reset = false;
            this.oldRect = r;
            double mapWidth = this.mapArea.getWidth();
            double mapHeight = this.mapArea.getHeight();
            double scaleX = r.getWidth() / this.mapArea.getWidth();
            double scaleY = r.getHeight() / this.mapArea.getHeight();
            double scale = 1.0;
            scale = scaleX < scaleY ? scaleX : scaleY;
            double deltaX = r.getWidth() / scale - mapWidth;
            double deltaY = r.getHeight() / scale - mapHeight;
            System.out.println("delta x " + deltaX);
            System.out.println("delta y " + deltaY);
            Coordinate ll = new Coordinate(this.mapArea.getMinX() - deltaX / 2.0, this.mapArea.getMinY() - deltaY / 2.0);
            Coordinate ur = new Coordinate(this.mapArea.getMaxX() + deltaX / 2.0, this.mapArea.getMaxY() + deltaY / 2.0);
            this.mapArea = new Envelope(ll, ur);
        }
        if (!this.mapArea.equals((Object)this.oldMapArea)) {
            changed = true;
            this.oldMapArea = this.mapArea;
        }
        if (changed) {
            this.baseImage = new BufferedImage(dr.width, dr.height, 2);
            Graphics2D ig = this.baseImage.createGraphics();
            this.renderer.setContext(this.context);
            this.renderer.paint(ig, dr, this.mapArea);
        }
        ((Graphics2D)g).drawImage((Image)this.baseImage, 0, 0, this);
        if (this.selection != null && this.selection.size() > 0) {
            String type = "polygon";
            if (type.equalsIgnoreCase("polygon")) {
                this.selectionStyle = this.polygonSelectionStyle;
            } else if (type.equalsIgnoreCase("point")) {
                this.selectionStyle = this.pointSelectionStyle;
            } else if (type.equalsIgnoreCase("line")) {
                this.selectionStyle = this.lineSelectionStyle;
            }
            this.selectionContext = new DefaultMapContext();
            this.selectionContext.addLayer(this.selection, this.selectionStyle);
            this.renderer.setContext(this.selectionContext);
            this.selectImage = new BufferedImage(dr.width, dr.height, 2);
            Graphics2D ig = this.selectImage.createGraphics();
            this.renderer.paint(ig, dr, this.mapArea);
            ((Graphics2D)g).drawImage((Image)this.selectImage, 0, 0, this);
        }
        if (this.highlight && this.highlightFeature != null && this.highlightFeature.size() > 0) {
            String type = "polygon";
            Style highlightStyle = null;
            if (type.equalsIgnoreCase("polygon")) {
                highlightStyle = this.polygonHighlightStyle;
            } else if (type.equalsIgnoreCase("point")) {
                highlightStyle = this.pointHighlightStyle;
            } else if (type.equalsIgnoreCase("line")) {
                highlightStyle = this.lineHighlightStyle;
            }
            DefaultMapContext highlightContext = new DefaultMapContext();
            highlightContext.addLayer(this.highlightFeature, highlightStyle);
            this.renderer.setContext((MapContext)highlightContext);
            this.renderer.paint((Graphics2D)g, dr, this.mapArea);
        }
    }

    public FeatureCollection doSelection(double x, double y, int layer) {
        GeometryFilter f = null;
        FeatureCollection select = null;
        Point geometry = this.gf.createPoint(new Coordinate(x, y));
        try {
            f = this.ff.createGeometryFilter((short)11);
            f.addRightGeometry((Expression)this.ff.createLiteralExpression((Object)geometry));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
        }
        if (layer == -1) {
            for (int i = 0; i < this.context.getLayers().length; ++i) {
                FeatureCollection fx = this.findFeature(f, i);
                if (select != null) {
                    select.addAll((Collection)fx);
                    continue;
                }
                select = fx;
            }
        } else {
            select = this.findFeature(f, layer);
        }
        return select;
    }

    private FeatureCollection findFeature(GeometryFilter f, int i) throws IndexOutOfBoundsException {
        FeatureCollection fcol = null;
        if (this.context != null && i > this.context.getLayers().length) {
            return fcol;
        }
        MapLayer layer = this.context.getLayer(i);
        try {
            String name = layer.getFeatureSource().getSchema().getDefaultGeometry().getName();
            if (name == "") {
                name = "the_geom";
            }
            f.addLeftGeometry((Expression)this.ff.createAttributeExpression(name));
            FeatureCollection fc = layer.getFeatureSource().getFeatures((Filter)f);
            if (fc.size() > 0) {
                this.selectionLayer = i;
            }
            if (fcol == null) {
                fcol = fc;
            } else {
                fcol.addAll((Collection)fc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
        }
        return fcol;
    }

    public void mouseClicked(MouseEvent e) {
        Rectangle bounds = this.getBounds();
        double x = e.getX();
        double y = e.getY();
        double width = this.mapArea.getWidth();
        double height = this.mapArea.getHeight();
        double width2 = this.mapArea.getWidth() / 2.0;
        double height2 = this.mapArea.getHeight() / 2.0;
        double mapX = x * width / (double)bounds.width + this.mapArea.getMinX();
        double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + this.mapArea.getMinY();
        double zlevel = 1.0;
        switch (this.state) {
            case 3: {
                zlevel = 1.0;
                break;
            }
            case 1: {
                zlevel = this.zoomFactor;
                break;
            }
            case 2: {
                zlevel = 1.0 / this.zoomFactor;
                break;
            }
            case 4: {
                this.selection = this.doSelection(mapX, mapY, this.selectionLayer);
                this.repaint();
                return;
            }
            default: {
                return;
            }
        }
        Coordinate ll = new Coordinate(mapX - width2 / zlevel, mapY - height2 / zlevel);
        Coordinate ur = new Coordinate(mapX + width2 / zlevel, mapY + height2 / zlevel);
        this.mapArea = new Envelope(ll, ur);
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private Style setupStyle(int type, Color color) {
        StyleFactory sf = StyleFactoryFinder.createStyleFactory();
        StyleBuilder sb = new StyleBuilder(sf, this.ff);
        Style s = sf.createStyle();
        s.setTitle("selection");
        PolygonSymbolizer ps = sb.createPolygonSymbolizer(color);
        ps.setStroke(sb.createStroke(color));
        LineSymbolizer ls = sb.createLineSymbolizer(color);
        Graphic h = sb.createGraphic();
        h.setMarks(new Mark[]{sb.createMark("square", color)});
        PointSymbolizer pts = sb.createPointSymbolizer(h);
        switch (type) {
            case 0: {
                s = sb.createStyle((Symbolizer)ps);
                break;
            }
            case 2: {
                s = sb.createStyle((Symbolizer)pts);
                break;
            }
            case 1: {
                s = sb.createStyle((Symbolizer)ls);
            }
        }
        return s;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void highlightChanged(HighlightChangedEvent e) {
        Filter f = e.getFilter();
        try {
            this.highlightFeature = this.highlightLayer.getFeatureSource().getFeatures(f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equalsIgnoreCase("crs")) {
            this.context.setAreaOfInterest((Envelope)this.context.getAreaOfInterest(), (CoordinateReferenceSystem)evt.getNewValue());
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }
}

