/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.units.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadata;
import org.geotools.gce.imageio.asciigrid.spi.AsciiGridsImageReaderSpi;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ArcGridReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.arcgrid");
    private static final ImageReaderSpi readerSPI = new AsciiGridsImageReaderSpi();
    private String parentPath;
    private double inNoData = Double.NaN;

    public ArcGridReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public ArcGridReader(Object input, Hints hints) throws DataSourceException {
        this.coverageName = "AsciiGrid";
        try {
            this.checkSource(input);
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
            } else {
                this.getCoordinateReferenceSystem();
            }
            ImageReader reader = readerSPI.createReaderInstance();
            reader.setInput(this.inStream);
            IIOMetadata metadata = reader.getImageMetadata(0);
            if (!(metadata instanceof AsciiGridsImageMetadata)) {
                throw new DataSourceException("Unexpected error! Metadata are not of the expected class.");
            }
            AsciiGridsImageMetadata gridMetadata = (AsciiGridsImageMetadata)metadata;
            this.parseMetadata(gridMetadata);
            this.getResolutionInfo(reader);
            this.finalStreamPreparation();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void finalStreamPreparation() throws IOException {
        if (this.closeMe) {
            this.inStream.close();
        } else {
            this.inStream.reset();
            this.inStream.mark();
        }
    }

    private void checkSource(Object input) throws UnsupportedEncodingException, DataSourceException, IOException, FileNotFoundException {
        URL sourceURL;
        if (input == null) {
            DataSourceException ex = new DataSourceException("No source set to read this coverage.");
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            throw ex;
        }
        this.source = input;
        if (this.hints != null) {
            this.hints.add((RenderingHints)this.hints);
        }
        this.closeMe = true;
        if (input instanceof URL && (sourceURL = (URL)input).getProtocol().compareToIgnoreCase("file") == 0) {
            this.source = input = new File(URLDecoder.decode(sourceURL.getFile(), "UTF-8"));
        }
        if (input instanceof File) {
            File sourceFile = (File)input;
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
            this.parentPath = sourceFile.getParent();
            this.coverageName = sourceFile.getName();
            int dotIndex = this.coverageName.indexOf(".");
            this.gzipped = this.coverageName.toLowerCase().endsWith("gz");
            this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
            this.inStream = this.gzipped ? ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream(sourceFile))) : ImageIO.createImageInputStream(sourceFile);
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            input = tempURL.openConnection().getInputStream();
            GZIPInputStream gzInStream = null;
            try {
                gzInStream = new GZIPInputStream((InputStream)input);
                this.gzipped = false;
            }
            catch (Exception e) {
                this.gzipped = false;
            }
            input = tempURL.openConnection().getInputStream();
            this.inStream = this.gzipped ? ImageIO.createImageInputStream(gzInStream) : ImageIO.createImageInputStream(tempURL.openConnection().getInputStream());
        } else if (input instanceof InputStream) {
            this.closeMe = false;
            this.inStream = ImageIO.getUseCache() ? new FileCacheImageInputStream((InputStream)input, null) : new MemoryCacheImageInputStream((InputStream)input);
            this.inStream.mark();
        } else if (input instanceof ImageInputStream) {
            this.closeMe = false;
            this.inStream = (ImageInputStream)input;
            this.inStream.mark();
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        if (this.inStream == null) {
            throw new DataSourceException("No input stream for the provided source");
        }
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle actualDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        this.originalGridRange = new GeneralGridRange(actualDim);
        this.highestRes = this.getResolution(this.originalEnvelope, actualDim, this.crs);
    }

    public Format getFormat() {
        return new ArcGridFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope readEnvelope = null;
        Rectangle requestedDim = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                Parameter param = (Parameter)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                readEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                requestedDim = gg.getGridRange2D().getBounds();
            }
        }
        return this.createCoverage(readEnvelope, requestedDim);
    }

    private GridCoverage createCoverage(GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException {
        Integer imageChoice;
        if (!this.closeMe) {
            this.inStream.reset();
            this.inStream.mark();
        }
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(readP, requestedEnvelope, requestedDim);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        ParameterBlock pbjImageRead = new ParameterBlock();
        if (this.source instanceof File) {
            if (!this.gzipped) {
                pbjImageRead.add(ImageIO.createImageInputStream(this.source));
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(new GZIPInputStream(new FileInputStream((File)this.source))));
            }
        } else if (this.source instanceof ImageInputStream || this.source instanceof InputStream) {
            pbjImageRead.add(this.inStream);
        } else if (this.source instanceof URL) {
            if (this.gzipped) {
                ImageIO.createImageInputStream(new GZIPInputStream(((URL)this.source).openConnection().getInputStream()));
            } else {
                pbjImageRead.add(ImageIO.createImageInputStream(((URL)this.source).openConnection().getInputStream()));
            }
        }
        pbjImageRead.add(imageChoice);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(null);
        pbjImageRead.add(null);
        pbjImageRead.add(readP);
        pbjImageRead.add(readerSPI.createReaderInstance());
        RenderedOp asciiCoverage = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)this.hints);
        try {
            Unit uom = null;
            Category values = new Category((CharSequence)"values", demColors, new NumberRange(1, 255), new NumberRange(0, 8849));
            Category nan = Double.isNaN(this.inNoData) ? new Category((CharSequence)"No Data", new Color(0, 0, 0, 0), 0) : new Category((CharSequence)"No Data", new Color[]{new Color(0, 0, 0, 0)}, new NumberRange(0, 0), new NumberRange(this.inNoData, this.inNoData));
            GridSampleDimension band = new GridSampleDimension((CharSequence)this.coverageName, new Category[]{nan, values}, uom).geophysics(true);
            HashMap<String, Double> properties = new HashMap<String, Double>();
            properties.put("GC_NODATA", new Double(this.inNoData));
            return coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)asciiCoverage, (Envelope)this.originalEnvelope, new GridSampleDimension[]{band}, null, properties);
        }
        catch (NoSuchElementException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private void parseMetadata(AsciiGridsImageMetadata gridMetadata) throws MismatchedDimensionException {
        Node root = gridMetadata.getAsTree("org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadata_1.0");
        Node child = root.getFirstChild();
        NamedNodeMap attributes = child.getAttributes();
        boolean grass = attributes.getNamedItem("GRASS").getNodeValue().equalsIgnoreCase("True");
        child = child.getNextSibling();
        attributes = child.getAttributes();
        int hrWidth = Integer.parseInt(attributes.getNamedItem("nColumns").getNodeValue());
        int hrHeight = Integer.parseInt(attributes.getNamedItem("nRows").getNodeValue());
        this.originalGridRange = new GeneralGridRange(new Rectangle(0, 0, hrWidth, hrHeight));
        boolean pixelIsArea = attributes.getNamedItem("rasterSpaceType").getNodeValue().equalsIgnoreCase(AsciiGridsImageMetadata.rasterSpaceTypes[1]);
        if (!grass) {
            this.inNoData = Double.parseDouble(attributes.getNamedItem("noDataValue").getNodeValue());
        }
        child = child.getNextSibling();
        attributes = child.getAttributes();
        double cellsizeX = Double.parseDouble(attributes.getNamedItem("cellsizeX").getNodeValue());
        double cellsizeY = Double.parseDouble(attributes.getNamedItem("cellsizeY").getNodeValue());
        double xll = Double.parseDouble(attributes.getNamedItem("xll").getNodeValue());
        double yll = Double.parseDouble(attributes.getNamedItem("yll").getNodeValue());
        if (!pixelIsArea) {
            double correctionX = cellsizeX / 2.0;
            double correctionY = cellsizeY / 2.0;
            xll -= correctionX;
            yll -= correctionY;
        }
        this.originalEnvelope = new GeneralEnvelope(new double[]{xll, yll}, new double[]{xll + (double)hrWidth * cellsizeX, yll + (double)hrHeight * cellsizeY});
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void getCoordinateReferenceSystem() throws FileNotFoundException, IOException {
        block19: {
            if ((this.source instanceof File || this.source instanceof URL && ((URL)this.source).getProtocol() == "file") && (prjFile = new File((base = new StringBuffer((sourceAsString = this.source instanceof File != false ? ((File)this.source).getAbsolutePath() : ((URL)this.source).getFile()).substring(0, index = sourceAsString.lastIndexOf("."))).append(".prj")).toString())).exists()) {
                projReader = null;
                try {
                    channel = new FileInputStream(prjFile).getChannel();
                    projReader = new PrjFileReader((ReadableByteChannel)channel);
                    this.crs = projReader.getCoodinateSystem();
                    var8_10 = null;
                    ** if (projReader == null) goto lbl-1000
                }
                catch (Throwable var7_20) {
                    var8_14 = null;
                    if (projReader != null) {
                        try {
                            projReader.close();
                        }
                        catch (IOException e) {
                            ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                    throw var7_20;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        projReader.close();
                    }
                    catch (IOException e) {
                        ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block19;
                    catch (FileNotFoundException e) {
                        ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        var8_11 = null;
                        if (projReader != null) {
                            try {
                                projReader.close();
                            }
                            catch (IOException e) {
                                ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                            }
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        var8_12 = null;
                        if (projReader != null) {
                            try {
                                projReader.close();
                            }
                            catch (IOException e) {
                                ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                            }
                        }
                        break block19;
                    }
                    catch (FactoryException e) {
                        ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        var8_13 = null;
                        if (projReader != null) {
                            try {
                                projReader.close();
                            }
                            catch (IOException e) {
                                ArcGridReader.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
            }
        }
        if (this.crs == null) {
            this.crs = AbstractGridFormat.getDefaultCRS();
            ArcGridReader.LOGGER.info("Unable to find crs, continuing with default WGS4 CRS" + "\n" + this.crs.toWKT());
        }
    }
}

