/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.Interpolation;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.data.DataSourceException;
import org.geotools.data.coverage.grid.AbstractGridCoverageWriter;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageMetadata;
import org.geotools.gce.imageio.asciigrid.AsciiGridsImageWriter;
import org.geotools.gce.imageio.asciigrid.spi.AsciiGridsImageWriterSpi;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.CoverageUtilities;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.spatialschema.geometry.Envelope;

public final class ArcGridWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.arcgrid");
    private AsciiGridsImageWriter mWriter = new AsciiGridsImageWriter((ImageWriterSpi)new AsciiGridsImageWriterSpi());
    private static final ParameterValueGroup bandSelectParams;
    private static final ParameterValueGroup reShapeParams;
    private static final Resample resampleFactory;
    private static final SelectSampleDimension bandSelectFactory;
    private static final double EPS = 1.0E-6;
    private boolean grass = false;
    private int writeBand = -1;

    public ArcGridWriter(Object destination) throws DataSourceException {
        this(destination, null);
    }

    public ArcGridWriter(Object destination, Hints hints) throws DataSourceException {
        this.destination = destination;
        if (destination instanceof File) {
            try {
                this.outStream = ImageIO.createImageOutputStream(destination);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                throw new DataSourceException((Throwable)e);
            }
        }
        if (destination instanceof URL) {
            URL dest = (URL)destination;
            if (dest.getProtocol().equalsIgnoreCase("file")) {
                File destFile;
                try {
                    destFile = new File(URLDecoder.decode(dest.getFile(), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    throw new DataSourceException((Throwable)e);
                }
                try {
                    this.outStream = ImageIO.createImageOutputStream(destFile);
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    throw new DataSourceException((Throwable)e);
                }
            }
        } else if (destination instanceof OutputStream) {
            try {
                this.outStream = ImageIO.createImageOutputStream((OutputStream)destination);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                throw new DataSourceException((Throwable)e);
            }
        } else if (destination instanceof ImageOutputStream) {
            this.outStream = (ImageOutputStream)destination;
            this.destination = this.outStream;
        } else {
            throw new DataSourceException("The provided destination cannot be used!");
        }
        if (hints != null) {
            if (this.hints == null) {
                this.hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            this.hints.add((RenderingHints)hints);
        }
    }

    public Format getFormat() {
        return new ArcGridFormat();
    }

    private void setEnvironment(GeneralParameterValue[] parameters, GridCoverage2D gc2D) throws InvalidParameterNameException, InvalidParameterValueException, IOException {
        GeoToolsWriteParams gtParams = null;
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = (Parameter)parameters[i];
                String name = param.getDescriptor().getName().toString();
                if (param.getDescriptor().getName().getCode().equals(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString())) {
                    gtParams = (GeoToolsWriteParams)param.getValue();
                }
                if (!name.equalsIgnoreCase("GRASS")) continue;
                this.grass = param.booleanValue();
            }
        }
        if (gtParams == null) {
            gtParams = new ArcGridWriteParams();
        }
        int[] writeBands = gtParams.getSourceBands();
        this.writeBand = CoverageUtilities.getVisibleBand(gc2D.getRenderedImage());
        if (!(writeBands != null && writeBands.length != 0 && writeBands.length <= 1 || this.writeBand >= 0 && this.writeBand <= gc2D.getNumSampleDimensions())) {
            throw new IllegalArgumentException("You need to supply a valid index for deciding which band to write.");
        }
        if (writeBands != null && writeBands.length != 0 && writeBands.length <= 1) {
            this.writeBand = writeBands[0];
        }
    }

    private void writeGridCoverage(GridCoverage2D gc) throws DataSourceException {
        try {
            CoordinateReferenceSystem crs = gc.getCoordinateReferenceSystem();
            Envelope oldEnv = gc.getEnvelope();
            int numBands = gc.getNumSampleDimensions();
            if (numBands > 1) {
                int visibleBand = this.writeBand > 0 && this.writeBand < numBands ? this.writeBand : CoverageUtilities.getVisibleBand(gc);
                ParameterValueGroup param = (ParameterValueGroup)bandSelectParams.clone();
                param.parameter("source").setValue((Object)gc);
                param.parameter("SampleDimensions").setValue((Object)new int[]{visibleBand});
                gc = (GridCoverage2D)bandSelectFactory.doOperation(param, null);
            }
            if (!this.grass) {
                gc = this.reShapeData(gc);
            }
            Envelope newEnv = gc.getEnvelope();
            AffineTransform gridToWorld = (AffineTransform)((GridGeometry2D)gc.getGridGeometry()).getGridToCRS2D();
            double xl = newEnv.getLowerCorner().getOrdinate(0);
            double yl = newEnv.getLowerCorner().getOrdinate(1);
            double cellsizeX = Math.abs(gridToWorld.getScaleX());
            double cellsizeY = Math.abs(gridToWorld.getScaleY());
            RenderedImage source = gc.getRenderedImage();
            int cols = source.getWidth();
            int rows = source.getHeight();
            this.mWriter.setOutput((Object)this.outStream);
            double inNoData = ArcGridWriter.getCandidateNoData(gc);
            this.mWriter.write(null, new IIOImage(source, null, (IIOMetadata)new AsciiGridsImageMetadata(cols, rows, cellsizeX, cellsizeY, xl, yl, true, this.grass, inNoData)), null);
            this.writeCRSInfo(crs);
            this.mWriter.dispose();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
    }

    private GridCoverage2D reShapeData(GridCoverage2D gc) {
        double dy;
        AffineTransform gridToWorld = (AffineTransform)((GridGeometry2D)gc.getGridGeometry()).getGridToCRS2D();
        double dx = XAffineTransform.getScaleX0((AffineTransform)gridToWorld);
        if (Math.abs(dx - (dy = XAffineTransform.getScaleY0((AffineTransform)gridToWorld))) <= 1.0E-6) {
            return gc;
        }
        RenderedImage image = gc.getRenderedImage();
        int Nx = image.getWidth();
        int Ny = image.getHeight();
        Envelope2D oldEnv = gc.getEnvelope2D();
        double W = oldEnv.getLength(0);
        double H = oldEnv.getLength(1);
        if (dx - dy > 1.0E-6) {
            double _Nx = W / dy;
            Nx = (int)Math.round(_Nx);
        } else {
            double _Ny = H / dx;
            Ny = (int)Math.round(_Ny);
        }
        GeneralGridRange newGridrange = new GeneralGridRange(new int[]{0, 0}, new int[]{Nx, Ny});
        GridGeometry2D newGridGeometry = new GridGeometry2D(newGridrange, (Envelope)new GeneralEnvelope(gc.getEnvelope()));
        ParameterValueGroup param = (ParameterValueGroup)reShapeParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)gc.getCoordinateReferenceSystem2D());
        param.parameter("GridGeometry").setValue((Object)newGridGeometry);
        param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
        return (GridCoverage2D)resampleFactory.doOperation(param, this.hints);
    }

    private void writeCRSInfo(CoordinateReferenceSystem crs) throws IOException {
        if (crs == null) {
            throw new IllegalArgumentException("CRS cannot be null!");
        }
        URL url = null;
        String pathname = null;
        String name = null;
        if (this.destination instanceof String) {
            url = new File((String)this.destination).toURL();
            pathname = url.getPath().substring(0, url.getPath().lastIndexOf("/") + 1);
            name = url.getPath().substring(url.getPath().lastIndexOf("/") + 1, url.getPath().length());
        } else if (this.destination instanceof File) {
            url = ((File)this.destination).toURL();
            pathname = url.getPath().substring(0, url.getPath().lastIndexOf("/") + 1);
            name = url.getPath().substring(url.getPath().lastIndexOf("/") + 1, url.getPath().length());
        } else if (this.destination instanceof URL) {
            url = (URL)this.destination;
            pathname = url.getPath().substring(0, url.getPath().lastIndexOf("/") + 1);
            name = url.getPath().substring(url.getPath().lastIndexOf("/") + 1, url.getPath().length());
        } else {
            return;
        }
        name = pathname + (name.indexOf(".") > 0 ? name.substring(0, name.indexOf(".")) : name) + ".prj";
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(name));
        fileWriter.write(crs.toWKT());
        fileWriter.close();
    }

    public void write(GridCoverage coverage, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        ArcGridWriter.ensureWeCanWrite(coverage, parameters);
        if (parameters != null) {
            this.setEnvironment(parameters, (GridCoverage2D)coverage);
        }
        this.writeGridCoverage((GridCoverage2D)coverage);
    }

    private static void ensureWeCanWrite(GridCoverage coverage, GeneralParameterValue[] parameters) throws IOException {
        AffineTransform gridToWorldTransform = new AffineTransform((AffineTransform)((GridGeometry2D)coverage.getGridGeometry()).getGridToCRS2D());
        XAffineTransform.round((AffineTransform)gridToWorldTransform, (double)1.0E-6);
        int swapXY = XAffineTransform.getSwapXY((AffineTransform)gridToWorldTransform);
        double rotation = XAffineTransform.getRotation((AffineTransform)gridToWorldTransform);
        if (rotation != 0.0) {
            throw new IOException("Impossible to encode this coverage as an ascii grid since itstransformation is not a simple scale and translate");
        }
        if (swapXY == -1) {
            throw new IOException("Impossible to encode this coverage as an ascii grid since itstransformation is not a simple scale and translate");
        }
        int flip = XAffineTransform.getFlip((AffineTransform)gridToWorldTransform);
        CoordinateReferenceSystem crs2D = ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        if (flip > 0) {
            throw new IOException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
        if (!AxisDirection.NORTH.equals(crs2D.getCoordinateSystem().getAxis(1).getDirection())) {
            throw new IOException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
        if (!AxisDirection.EAST.equals(crs2D.getCoordinateSystem().getAxis(0).getDirection())) {
            throw new IOException("Impossible to encode this coverage as an ascii grid since itscoordinate reference system has strange axes orientation");
        }
    }

    public void dispose() {
        if (this.mWriter != null) {
            this.mWriter.dispose();
            this.mWriter = null;
        }
    }

    static double getCandidateNoData(GridCoverage2D gc) {
        GridSampleDimension sd = (GridSampleDimension)gc.getSampleDimension(0);
        List categories = sd.getCategories();
        Iterator it = categories.iterator();
        double inNoData = Double.NaN;
        String noDataName = Vocabulary.format((int)110);
        while (it.hasNext()) {
            Category candidate = (Category)it.next();
            String name = candidate.getName().toString();
            if (!name.equalsIgnoreCase("No Data") && !name.equalsIgnoreCase(noDataName)) continue;
            inNoData = candidate.getRange().getMaximum();
        }
        return inNoData;
    }

    static {
        resampleFactory = new Resample();
        bandSelectFactory = new SelectSampleDimension();
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        bandSelectParams = processor.getOperation("SelectSampleDimension").getParameters();
        reShapeParams = processor.getOperation("Resample").getParameters();
    }
}

