/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mif;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.mif.MIFFile;
import org.geotools.feature.FeatureType;

public class MIFDataStore
extends AbstractDataStore {
    public static final String HCLAUSE_VERSION = "version";
    public static final String HCLAUSE_CHARSET = "charset";
    public static final String HCLAUSE_DELIMITER = "delimiter";
    public static final String HCLAUSE_UNIQUE = "unique";
    public static final String HCLAUSE_INDEX = "index";
    public static final String HCLAUSE_COORDSYS = "coordsys";
    public static final String HCLAUSE_TRANSFORM = "transform";
    public static final String PARAM_FIELDCASE = "fieldCase";
    public static final String PARAM_GEOMFACTORY = "geometryFactory";
    public static final String PARAM_GEOMNAME = "geometryFieldName";
    public static final String PARAM_GEOMTYPE = "geometryType";
    public static final String PARAM_SRID = "SRID";
    private File filePath;
    private HashMap params = null;
    private HashMap mifFileHolders = new HashMap();

    public MIFDataStore(String path, HashMap params) throws IOException {
        super(true);
        this.params = params != null ? params : new HashMap();
        this.filePath = new File(String.valueOf(path));
        if (this.filePath.isDirectory()) {
            this.scanFiles(this.filePath);
        } else {
            this.registerMIF(this.filePath.getAbsolutePath());
        }
    }

    private int scanFiles(File filePath) throws IOException {
        if (!filePath.isDirectory()) {
            return 0;
        }
        File[] files = filePath.listFiles();
        int found = 0;
        for (int i = 0; i < files.length; ++i) {
            String fName = files[i].getName();
            if (fName.length() <= 4 || fName.toLowerCase().indexOf(".mif") != fName.length() - 4 || this.mifFileHolders.get(fName = fName.substring(0, fName.length() - 4)) != null) continue;
            this.registerMIF(files[i].getAbsolutePath());
            ++found;
        }
        return found;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        if (!this.filePath.isDirectory()) {
            throw new IOException("Can't create schema on a MIF DataStore instantiated from a single MIF file");
        }
        try {
            File newFile = new File(this.filePath, featureType.getTypeName() + ".mif");
            MIFFile mf = new MIFFile(newFile.getAbsolutePath(), featureType, this.params);
            MIFFileHolder mfh = new MIFFileHolder(mf);
            this.mifFileHolders.put(mf.getSchema().getTypeName(), mfh);
        }
        catch (Exception e) {
            throw new IOException("Unable to create MIFFile object: " + e.getMessage());
        }
    }

    public String[] getTypeNames() throws IOException {
        this.scanFiles(this.filePath);
        String[] names = new String[this.mifFileHolders.size()];
        int index = 0;
        Iterator i = this.mifFileHolders.keySet().iterator();
        while (i.hasNext()) {
            names[index++] = (String)i.next();
        }
        return names;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        return this.getMIFFile(typeName).getSchema();
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getMIFFile(typeName).getFeatureReader();
    }

    protected FeatureWriter getFeatureWriter(String typeName) throws IOException {
        return this.getMIFFile(typeName).getFeatureWriter();
    }

    private void registerMIF(String path) throws IOException {
        MIFFile mf = new MIFFile(path, this.params);
        MIFFileHolder mfh = new MIFFileHolder(mf);
        FeatureType ft = mf.getSchema();
        this.mifFileHolders.put(ft.getTypeName(), mfh);
    }

    private MIFFile getMIFFile(String typeName) {
        MIFFileHolder mifHolder = (MIFFileHolder)this.mifFileHolders.get(typeName);
        if (mifHolder != null) {
            return mifHolder.mifFile;
        }
        try {
            if (this.scanFiles(this.filePath) == 0) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mifHolder = (MIFFileHolder)this.mifFileHolders.get(typeName);
        if (mifHolder != null) {
            return mifHolder.mifFile;
        }
        return null;
    }

    private class MIFFileHolder {
        private MIFFile mifFile = null;

        private MIFFileHolder(MIFFile mifFile) {
            this.mifFile = mifFile;
        }
    }
}

