/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mif;

import com.vividsolutions.jts.io.ParseException;

public class MIFStringTokenizer {
    private String line = "";
    private String lastToken = null;

    public boolean readLine(String line) {
        this.line = line == null ? "" : MIFStringTokenizer.ltrim(line);
        return !line.equals("");
    }

    public boolean readLine() {
        return this.readLine("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToken(char separator, boolean nextLineIfEmpty, boolean quotedStrings) throws ParseException {
        String token = "";
        if (this.lastToken != null) {
            token = this.lastToken;
            this.lastToken = null;
            return token;
        }
        this.line = MIFStringTokenizer.ltrim(this.line);
        if (this.line.equals("") && nextLineIfEmpty) {
            this.readLine();
        }
        if (this.line.equals("")) {
            return "";
        }
        int index = -1;
        if (quotedStrings && this.line.startsWith("\"")) {
            try {
                index = 1;
                boolean loop = true;
                int len = this.line.length();
                while (loop) {
                    while (index < len && this.line.charAt(index) != '\"') {
                        ++index;
                    }
                    if (index < len - 1 && this.line.charAt(index + 1) == '\"') {
                        index += 2;
                        continue;
                    }
                    loop = false;
                }
                token = this.line.substring(1, index).replaceAll("\"\"", "\"");
                this.line = MIFStringTokenizer.ltrim(this.line.substring(index + 1));
                if (this.line.length() <= 0) return token;
                if (this.line.charAt(0) == separator) {
                    this.line = this.line.substring(1);
                    return token;
                }
                if (separator == ' ') return token;
                throw new ParseException("Bad separator");
            }
            catch (Exception e) {
                throw new ParseException("Error reading quoted string");
            }
        } else {
            index = this.line.indexOf(separator);
            if (index == -1) {
                token = this.line;
                this.line = "";
                return token;
            } else {
                token = MIFStringTokenizer.ltrim(this.line.substring(0, index));
                this.line = MIFStringTokenizer.ltrim(this.line.substring(index + 1));
            }
        }
        return token;
    }

    protected String getToken(char separator, boolean nextLineIfEmpty) throws ParseException {
        return this.getToken(separator, nextLineIfEmpty, false);
    }

    protected String getToken(char separator) throws ParseException {
        return this.getToken(separator, false, false);
    }

    protected String getToken() throws ParseException {
        return this.getToken(' ', false, false);
    }

    public void putToken(String tok) {
        this.lastToken = tok;
    }

    public static String strQuote(String unquoted) {
        return "\"" + unquoted.replaceAll("\"", "\"\"") + "\"";
    }

    public static String strUnquote(String quoted) {
        if (quoted.startsWith("\"") && quoted.endsWith("\"") && quoted.length() > 1) {
            quoted = quoted.substring(1, quoted.length() - 1).replaceAll("\"\"", "\"");
        }
        return quoted;
    }

    public static String ltrim(String untrimmed) {
        while (untrimmed.length() > 0 && untrimmed.charAt(0) == ' ') {
            untrimmed = untrimmed.substring(1);
        }
        return untrimmed;
    }

    public String getLine() {
        return this.line;
    }

    public boolean isEmpty() {
        return this.line.equals("");
    }
}

