/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Iterator;
import org.geotools.feature.AttributeType;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;

public class AttributeTypes {
    public static final int FIELD_LENGTH_UNDEFINED = 0;

    public static int getFieldLength(AttributeType attr, int defaultLength) {
        int length = AttributeTypes.getFieldLengthFromFilter(attr.getRestriction());
        if (length == 0) {
            length = defaultLength;
        }
        return length;
    }

    public static int getFieldLength(AttributeType attr) {
        return AttributeTypes.getFieldLength(attr, 0);
    }

    public static int getFieldLengthFromFilter(Filter filter) {
        int length = 0;
        if (filter != null && filter != Filter.ALL && filter != Filter.NONE) {
            short filterType = filter.getFilterType();
            if (filterType == 15 || filterType == 17 || filterType == 14) {
                try {
                    CompareFilter cf = (CompareFilter)filter;
                    if (cf.getLeftValue() instanceof LengthFunction) {
                        length = Integer.parseInt(((LiteralExpression)cf.getRightValue()).getLiteral().toString());
                    } else if (cf.getRightValue() instanceof LengthFunction) {
                        length = Integer.parseInt(((LiteralExpression)cf.getLeftValue()).getLiteral().toString());
                    }
                    if (filterType == 15) {
                        --length;
                    }
                }
                catch (NumberFormatException e) {}
            } else if (filterType == 2 || filterType == 1) {
                Iterator it = ((LogicFilter)filter).getFilterIterator();
                while (it.hasNext()) {
                    Filter subFilter = (Filter)it.next();
                    int subLength = AttributeTypes.getFieldLengthFromFilter(subFilter);
                    if (subLength <= length) continue;
                    length = subLength;
                }
            }
        }
        return length;
    }
}

