/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.openoffice;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.sheet.XAddIn;
import com.sun.star.uno.AnyConverter;
import com.sun.star.util.Date;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.openoffice.MethodInfo;
import org.geotools.resources.Utilities;

public abstract class Formulas
extends WeakBase
implements XAddIn,
XServiceName,
XServiceInfo {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.openoffice");
    protected static final long DAY_TO_MILLIS = 86400000L;
    protected final Map methods = new HashMap();
    private Locale locale;
    private transient java.util.Locale javaLocale;
    private transient Calendar calendar;

    protected Formulas() {
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.javaLocale = null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected final java.util.Locale getJavaLocale() {
        if (this.javaLocale == null) {
            if (this.locale != null) {
                String variant;
                String country;
                String language = this.locale.Language;
                if (language == null) {
                    language = "";
                }
                if ((country = this.locale.Country) == null) {
                    country = "";
                }
                if ((variant = this.locale.Variant) == null) {
                    variant = "";
                }
                this.javaLocale = new java.util.Locale(language, country, variant);
            } else {
                this.javaLocale = java.util.Locale.getDefault();
            }
        }
        return this.javaLocale;
    }

    public abstract String getServiceName();

    public String getImplementationName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProgrammaticCategoryName(String function) {
        MethodInfo info = (MethodInfo)this.methods.get(function);
        return info != null ? info.category : "Add-In";
    }

    public String getDisplayCategoryName(String function) {
        return this.getProgrammaticCategoryName(function);
    }

    public String getProgrammaticFuntionName(String display) {
        Iterator it = this.methods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!display.equals(((MethodInfo)entry.getValue()).display)) continue;
            return (String)entry.getKey();
        }
        return "";
    }

    public String getDisplayFunctionName(String function) {
        MethodInfo info = (MethodInfo)this.methods.get(function);
        return info != null ? info.display : "";
    }

    public String getFunctionDescription(String function) {
        MethodInfo info = (MethodInfo)this.methods.get(function);
        return info != null ? info.description : "";
    }

    public String getDisplayArgumentName(String function, int argument) {
        MethodInfo info = (MethodInfo)this.methods.get(function);
        if (info != null) {
            String[] arguments = info.arguments;
            if ((argument <<= 1) >= 0 && argument < arguments.length) {
                return arguments[argument];
            }
        }
        return "";
    }

    public String getArgumentDescription(String function, int argument) {
        MethodInfo info = (MethodInfo)this.methods.get(function);
        if (info != null) {
            argument = (argument << 1) + 1;
            String[] arguments = info.arguments;
            if (argument >= 0 && argument < arguments.length) {
                return arguments[argument];
            }
        }
        return "";
    }

    protected void setTimeZone(String timezone) {
        TimeZone tz = TimeZone.getTimeZone(timezone);
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar(tz);
        } else {
            this.calendar.setTimeZone(tz);
        }
    }

    protected java.util.Date getEpoch(XPropertySet xOptions) {
        Date date;
        try {
            date = (Date)AnyConverter.toObject((Class)Date.class, (Object)xOptions.getPropertyValue("NullDate"));
        }
        catch (Exception e) {
            this.reportException("getEpoch", e);
            return null;
        }
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        this.calendar.clear();
        this.calendar.set(date.Year, date.Month - 1, date.Day);
        return this.calendar.getTime();
    }

    protected java.util.Date toDate(XPropertySet xOptions, double time) {
        java.util.Date date = this.getEpoch(xOptions);
        if (date != null) {
            date.setTime(date.getTime() + Math.round(time * 8.64E7));
        }
        return date;
    }

    protected double toDouble(XPropertySet xOptions, java.util.Date time) {
        java.util.Date epoch = this.getEpoch(xOptions);
        if (epoch != null) {
            return (double)(time.getTime() - epoch.getTime()) / 8.64E7;
        }
        return Double.NaN;
    }

    static String emptyString() {
        return "(none)";
    }

    static int getLength(Object[] array1, Object[] array2) {
        if (array1 == null || array2 == null) {
            return 0;
        }
        if (array1.length == 1) {
            return array2.length;
        }
        if (array2.length == 1) {
            return array1.length;
        }
        return Math.min(array1.length, array2.length);
    }

    protected static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        return Utilities.getShortClassName(exception);
    }

    protected static double[][] getFailure(int rows, int cols) {
        double[][] dummy = new double[rows][];
        for (int i = 0; i < rows; ++i) {
            double[] row = new double[cols];
            Arrays.fill(row, Double.NaN);
            dummy[i] = row;
        }
        return dummy;
    }

    protected void reportException(String method, Throwable exception) {
        LogRecord record = new LogRecord(Level.FINE, Formulas.getLocalizedMessage(exception));
        record.setSourceClassName(Utilities.getShortClassName((Object)this));
        record.setSourceMethodName(method);
        record.setThrown(exception);
        this.getLogger().log(record);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

