/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.openoffice;

import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import org.geotools.nature.Calendar;
import org.geotools.nature.SeaWater;
import org.geotools.nature.SunRelativePosition;
import org.geotools.openoffice.Formulas;
import org.geotools.openoffice.MethodInfo;
import org.geotools.openoffice.XNature;

public final class Nature
extends Formulas
implements XNature {
    private static final String __serviceName = "org.geotools.openoffice.Nature";
    private static final String ADDIN_SERVICE = "com.sun.star.sheet.AddIn";
    private static final double DAY_TO_MILLIS = 8.64E7;
    private transient SunRelativePosition calculator;

    public Nature() {
        this.setTimeZone("GMT");
        this.methods.put("getNoonTime", new MethodInfo("Nature", "NOON.TIME", "Returns the noon time (in GMT) when the Sun reach its highest point.", new String[]{"xOptions", "Provided by OpenOffice.", "latitude", "The latitude of observation point, in degrees.", "longitude", "The longitude of observation point, in degrees.", "time", "The observation date."}));
        this.methods.put("getElevation", new MethodInfo("Nature", "SUN.ELEVATION", "Returns the Sun's elevation angle in degrees.", new String[]{"xOptions", "Provided by OpenOffice.", "latitude", "The latitude of observation point, in degrees.", "longitude", "The longitude of observation point, in degrees.", "time", "The observation date and time, in GMT."}));
        this.methods.put("getAzimuth", new MethodInfo("Nature", "SUN.AZIMUTH", "Returns the Sun's azimuth in degrees.", new String[]{"xOptions", "Provided by OpenOffice.", "latitude", "The latitude of observation point, in degrees.", "longitude", "The longitude of observation point, in degrees.", "time", "The observation date and time, in GMT."}));
        this.methods.put("getTropicalYearLength", new MethodInfo("Nature", "TROPICAL.YEAR.LENGTH", "Returns the tropical year length in days.", new String[]{"xOptions", "Provided by OpenOffice.", "time", "A date that contains the year."}));
        this.methods.put("getSynodicMonthLength", new MethodInfo("Nature", "SYNODIC.MONTH.LENGTH", "Returns the synodic month length in days.", new String[]{"xOptions", "Provided by OpenOffice.", "time", "A date that contains the month."}));
        this.methods.put("getSeaWaterDensity", new MethodInfo("Nature", "SEAWATER.DENSITY", "Computes sea water density (kg/m\u00b3) as a function of salinity, temperature and pressure.", new String[]{"xOptions", "Provided by OpenOffice.", "salinity", "Salinity PSS-78.", "temperature", "Temperature ITS-68.", "pressure", "Pressure in decibars, not including atmospheric pressure."}));
        this.methods.put("getSeaWaterMeltingPoint", new MethodInfo("Nature", "SEAWATER.MELTING.POINT", "Computes the sea water fusion temperature (melting point) as a function of salinity and pressure.", new String[]{"xOptions", "Provided by OpenOffice.", "salinity", "Salinity PSS-78.", "pressure", "Pressure in decibars, not including atmospheric pressure."}));
        this.methods.put("getSeaWaterSoundVelocity", new MethodInfo("Nature", "SEAWATER.SOUND.VELOCITY", "Computes the sound velocity in sea water as a function of salinity, temperature and pressure.", new String[]{"xOptions", "Provided by OpenOffice.", "salinity", "Salinity PSS-78.", "temperature", "Temperature ITS-68.", "pressure", "Pressure in decibars, not including atmospheric pressure."}));
        this.methods.put("getSeaWaterSaturationO2", new MethodInfo("Nature", "SEAWATER.OXYGEN.SATURATION", "Computes the saturation in disolved oxygen (\u00b5mol/kg) as a function of salinity and temperature.", new String[]{"xOptions", "Provided by OpenOffice.", "salinity", "Salinity PSS-78.", "temperature", "Temperature ITS-68."}));
    }

    public static XSingleServiceFactory __getServiceFactory(String implementation, XMultiServiceFactory factories, XRegistryKey registry) {
        if (implementation.equals(Nature.class.getName())) {
            return FactoryHelper.getServiceFactory((Class)Nature.class, (String)__serviceName, (XMultiServiceFactory)factories, (XRegistryKey)registry);
        }
        return null;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey registry) {
        String classname = Nature.class.getName();
        return FactoryHelper.writeRegistryServiceInfo((String)classname, (String)__serviceName, (XRegistryKey)registry) && FactoryHelper.writeRegistryServiceInfo((String)classname, (String)ADDIN_SERVICE, (XRegistryKey)registry);
    }

    public String getServiceName() {
        return __serviceName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{ADDIN_SERVICE, __serviceName};
    }

    public boolean supportsService(String name) {
        return name.equals(ADDIN_SERVICE) || name.equals(__serviceName);
    }

    private SunRelativePosition getSunRelativePosition(XPropertySet xOptions, double latitude, double longitude, double time) {
        if (this.calculator == null) {
            this.calculator = new SunRelativePosition(Double.NaN);
        }
        this.calculator.setCoordinate(longitude, latitude);
        this.calculator.setDate(this.toDate(xOptions, time));
        return this.calculator;
    }

    public double getNoonTime(XPropertySet xOptions, double latitude, double longitude, double time) {
        return (double)this.getSunRelativePosition(xOptions, latitude, longitude, time).getNoonTime() / 8.64E7;
    }

    public double getElevation(XPropertySet xOptions, double latitude, double longitude, double time) {
        return this.getSunRelativePosition(xOptions, latitude, longitude, time).getElevation();
    }

    public double getAzimuth(XPropertySet xOptions, double latitude, double longitude, double time) {
        return this.getSunRelativePosition(xOptions, latitude, longitude, time).getAzimuth();
    }

    public double getTropicalYearLength(XPropertySet xOptions, double time) {
        return Calendar.tropicalYearLength(this.toDate(xOptions, time));
    }

    public double getSynodicMonthLength(XPropertySet xOptions, double time) {
        return Calendar.synodicMonthLength(this.toDate(xOptions, time));
    }

    public double getSeaWaterDensity(XPropertySet xOptions, double salinity, double temperature, double pressure) {
        return SeaWater.density(salinity, temperature, pressure);
    }

    public double getSeaWaterMeltingPoint(XPropertySet xOptions, double salinity, double pressure) {
        return SeaWater.fusionTemperature(salinity, pressure);
    }

    public double getSeaWaterSoundVelocity(XPropertySet xOptions, double salinity, double temperature, double pressure) {
        return SeaWater.soundVelocity(salinity, temperature, pressure);
    }

    public double getSeaWaterSaturationO2(XPropertySet xOptions, double salinity, double temperature) {
        return SeaWater.saturationO2(salinity, temperature);
    }
}

