/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.openoffice;

import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.AnyConverter;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParseException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.openoffice.Formulas;
import org.geotools.openoffice.MethodInfo;
import org.geotools.openoffice.XReferencing;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.geometry.Position;
import org.opengis.util.InternationalString;

public final class Referencing
extends Formulas
implements XReferencing {
    private static final String __serviceName = "org.geotools.openoffice.Referencing";
    private static final String ADDIN_SERVICE = "com.sun.star.sheet.AddIn";
    private static final String AUTHORITY = "EPSG";
    private char decimalSeparator = (char)46;
    private transient String anglePattern;
    private transient Format angleFormat;
    private transient CRSAuthorityFactory crsFactory;
    private transient CoordinateOperationFactory opFactory;
    private transient CoordinateOperation lastOperation;
    private transient String lastSourceCRS;
    private transient String lastTargetCRS;
    private transient GeodeticCalculator calculator;
    private transient String calculatorCRS;

    public Referencing() {
        this.methods.put("getValueAngle", new MethodInfo("Text", "VALUE.ANGLE", "Converts text in degrees-minutes-seconds to an angle in decimal degrees.", new String[]{"xOptions", "Provided by OpenOffice.", "text", "The text to be converted to an angle.", "pattern", "The text that describes the format (example: \"D\u00b0MM.m'\")."}));
        this.methods.put("getTextAngle", new MethodInfo("Text", "TEXT.ANGLE", "Converts an angle to text according to a given format.", new String[]{"xOptions", "Provided by OpenOffice.", "value", "The angle value (in decimal degrees) to be converted.", "pattern", "The text that describes the format (example: \"D\u00b0MM.m'\")."}));
        this.methods.put("getTextLongitude", new MethodInfo("Text", "TEXT.LONGITUDE", "Converts a longitude to text according to a given format.", new String[]{"xOptions", "Provided by OpenOffice.", "value", "The longitude value (in decimal degrees) to be converted.", "pattern", "The text that describes the format (example: \"D\u00b0MM.m'\")."}));
        this.methods.put("getTextLatitude", new MethodInfo("Text", "TEXT.LATITUDE", "Converts a latitude to text according to a given format.", new String[]{"xOptions", "Provided by OpenOffice.", "value", "The latitude value (in decimal degrees) to be converted.", "pattern", "The text that describes the format (example: \"D\u00b0MM.m'\")."}));
        this.methods.put("getDescription", new MethodInfo("Referencing", "CRS.DESCRIPTION", "Returns a description for an object identified by the given authority code.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority."}));
        this.methods.put("getScope", new MethodInfo("Referencing", "CRS.SCOPE", "Returns the scope for an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority."}));
        this.methods.put("getValidArea", new MethodInfo("Referencing", "CRS.VALID.AREA", "Returns the valid area as a textual description for an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority."}));
        this.methods.put("getBoundingBox", new MethodInfo("Referencing", "CRS.BOUNDING.BOX", "Returns the valid area as a geographic bounding box for an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority."}));
        this.methods.put("getRemarks", new MethodInfo("Referencing", "CRS.REMARKS", "Returns the remarks for an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority."}));
        this.methods.put("getAxis", new MethodInfo("Referencing", "CRS.AXIS", "Returns the axis name for the specified dimension in an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority.", "dimension", "The dimension (1, 2, ...)."}));
        this.methods.put("getParameter", new MethodInfo("Referencing", "CRS.PARAMETER", "Returns the value for a coordinate reference system parameter.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority.", "parameter", "The parameter name (e.g. \"False easting\")."}));
        this.methods.put("getWKT", new MethodInfo("Referencing", "CRS.WKT", "Returns the Well Know Text (WKT) for an identified object.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority.", "authority", "The authority name for choice of parameter names."}));
        this.methods.put("getTransformWKT", new MethodInfo("Referencing", "TRANSFORM.WKT", "Returns the Well Know Text (WKT) of a transformation between two coordinate reference systems.", new String[]{"xOptions", "Provided by OpenOffice.", "code", "The code allocated by authority.", "authority", "The authority name for choice of parameter names."}));
        this.methods.put("getAccuracy", new MethodInfo("Referencing", "TRANSFORM.ACCURACY", "Returns the accuracy of a transformation between two coordinate reference systems.", new String[]{"xOptions", "Provided by OpenOffice.", "source CRS", "The source coordinate reference system.", "target CRS", "The target coordinate reference system."}));
        this.methods.put("getTransformedCoordinates", new MethodInfo("Referencing", "TRANSFORM.COORD", "Transform coordinates from the given source CRS to the given target CRS.", new String[]{"xOptions", "Provided by OpenOffice.", "coordinates", "The coordinate values to transform.", "source CRS", "The source coordinate reference system.", "target CRS", "The target coordinate reference system."}));
        this.methods.put("getOrthodromicDistance", new MethodInfo("Referencing", "ORTHODROMIC.DISTANCE", "Computes the orthodromic distance and azimuth between two coordinates.", new String[]{"xOptions", "Provided by OpenOffice.", "source", "The source positions.", "target", "The target positions.", "CRS", "Authority code of the coordinate reference system."}));
        this.methods.put("getOrthodromicForward", new MethodInfo("Referencing", "ORTHODROMIC.FORWARD", "Computes the coordinates after a displacement of the specified distance.", new String[]{"xOptions", "Provided by OpenOffice.", "source", "The source positions.", "displacement", "The distance and azimuth.", "CRS", "Authority code of the coordinate reference system."}));
    }

    public static XSingleServiceFactory __getServiceFactory(String implementation, XMultiServiceFactory factories, XRegistryKey registry) {
        if (implementation.equals(Referencing.class.getName())) {
            return FactoryHelper.getServiceFactory((Class)Referencing.class, (String)__serviceName, (XMultiServiceFactory)factories, (XRegistryKey)registry);
        }
        return null;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey registry) {
        String classname = Referencing.class.getName();
        return FactoryHelper.writeRegistryServiceInfo((String)classname, (String)__serviceName, (XRegistryKey)registry) && FactoryHelper.writeRegistryServiceInfo((String)classname, (String)ADDIN_SERVICE, (XRegistryKey)registry);
    }

    public String getServiceName() {
        return __serviceName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{ADDIN_SERVICE, __serviceName};
    }

    public boolean supportsService(String name) {
        return name.equals(ADDIN_SERVICE) || name.equals(__serviceName);
    }

    public void setLocale(Locale locale) {
        this.anglePattern = null;
        this.angleFormat = null;
        super.setLocale(locale);
    }

    private CRSAuthorityFactory crsFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = FactoryFinder.getCRSAuthorityFactory(AUTHORITY, null);
        }
        return this.crsFactory;
    }

    private CoordinateOperation getCoordinateOperation(String method, String source, String target) throws FactoryException {
        if (this.lastOperation != null && this.lastSourceCRS.equals(source) && this.lastTargetCRS.equals(target)) {
            return this.lastOperation;
        }
        CRSAuthorityFactory crsFactory = this.crsFactory();
        CoordinateReferenceSystem sourceCRS = crsFactory.createCoordinateReferenceSystem(source);
        CoordinateReferenceSystem targetCRS = crsFactory.createCoordinateReferenceSystem(target);
        if (this.opFactory == null) {
            this.opFactory = FactoryFinder.getCoordinateOperationFactory(new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE));
        }
        CoordinateOperation operation = this.opFactory.createOperation(sourceCRS, targetCRS);
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINER)) {
            LogRecord record = Logging.format(Level.FINER, 28, Referencing.getIdentifier((IdentifiedObject)operation), Referencing.getIdentifier((IdentifiedObject)sourceCRS), Referencing.getIdentifier((IdentifiedObject)targetCRS));
            record.setSourceClassName("Referencing");
            record.setSourceMethodName(method);
            logger.log(record);
        }
        this.lastSourceCRS = source;
        this.lastTargetCRS = target;
        this.lastOperation = operation;
        return operation;
    }

    private static String getIdentifier(IdentifiedObject object) {
        Set identifiers = object.getIdentifiers();
        if (identifiers != null && !identifiers.isEmpty()) {
            return ((Identifier)identifiers.iterator().next()).getCode();
        }
        return object.getName().getCode();
    }

    private static String toWKT(Object object, Object authority) throws IllegalArgumentException, UnsupportedOperationException {
        String authorityString = AnyConverter.isVoid((Object)authority) ? "OGC" : AnyConverter.toString((Object)authority);
        if (object instanceof Formattable) {
            return ((Formattable)object).toWKT(Citations.fromName(authorityString), 2);
        }
        if (object instanceof MathTransform) {
            return ((MathTransform)object).toWKT();
        }
        return ((IdentifiedObject)object).toWKT();
    }

    private GeodeticCalculator getGeodeticCalculator(Object authorityCode) throws IllegalArgumentException, FactoryException {
        String authorityString = AnyConverter.isVoid((Object)authorityCode) ? "EPSG:4326" : AnyConverter.toString((Object)authorityCode);
        if (this.calculatorCRS == null || !this.calculatorCRS.equals(authorityString)) {
            IdentifiedObject object = this.crsFactory().createObject(authorityString);
            if (object instanceof Ellipsoid) {
                this.calculator = new GeodeticCalculator((Ellipsoid)object);
            } else if (object instanceof GeodeticDatum) {
                this.calculator = new GeodeticCalculator(((GeodeticDatum)object).getEllipsoid());
            } else if (object instanceof CoordinateReferenceSystem) {
                this.calculator = new GeodeticCalculator((CoordinateReferenceSystem)object);
            } else {
                throw new FactoryException(Errors.format(46));
            }
            this.calculatorCRS = authorityString;
        }
        return this.calculator;
    }

    private Format getAngleFormat(Object pattern) throws IllegalArgumentException {
        String patternString = AnyConverter.isVoid((Object)pattern) ? "D\u00b0MM'SS.s\"" : AnyConverter.toString((Object)pattern);
        if (this.angleFormat == null) {
            java.util.Locale locale = this.getJavaLocale();
            this.angleFormat = new AngleFormat(patternString, locale);
            this.anglePattern = patternString;
            this.decimalSeparator = new DecimalFormatSymbols(locale).getDecimalSeparator();
        } else if (!patternString.equals(this.anglePattern)) {
            ((AngleFormat)this.angleFormat).applyPattern(patternString);
            this.anglePattern = patternString;
        }
        return this.angleFormat;
    }

    public double getValueAngle(XPropertySet xOptions, String text, Object pattern) throws IllegalArgumentException {
        AngleFormat angleFormat = (AngleFormat)this.getAngleFormat(pattern);
        try {
            return angleFormat.parse(text).degrees();
        }
        catch (ParseException exception) {
            String localized = text.replace('.', this.decimalSeparator);
            if (localized != text) {
                try {
                    return angleFormat.parse(localized).degrees();
                }
                catch (ParseException ignore) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(Referencing.getLocalizedMessage(exception));
        }
    }

    public String getTextAngle(XPropertySet xOptions, double value, Object pattern) throws IllegalArgumentException {
        return this.getAngleFormat(pattern).format(new Angle(value));
    }

    public String getTextLongitude(XPropertySet xOptions, double value, Object pattern) throws IllegalArgumentException {
        return this.getAngleFormat(pattern).format(new Longitude(value));
    }

    public String getTextLatitude(XPropertySet xOptions, double value, Object pattern) throws IllegalArgumentException {
        return this.getAngleFormat(pattern).format(new Latitude(value));
    }

    public String getDescription(XPropertySet xOptions, String authorityCode) {
        InternationalString description;
        try {
            description = this.crsFactory().getDescriptionText(authorityCode);
        }
        catch (Exception exception) {
            return Referencing.getLocalizedMessage(exception);
        }
        return description != null ? description.toString(this.getJavaLocale()) : Referencing.emptyString();
    }

    public String getScope(XPropertySet xOptions, String authorityCode) {
        IdentifiedObject object;
        try {
            object = this.crsFactory().createObject(authorityCode);
        }
        catch (Exception exception) {
            return Referencing.getLocalizedMessage(exception);
        }
        Object description = object instanceof Datum ? ((Datum)object).getScope() : (object instanceof ReferenceSystem ? ((ReferenceSystem)object).getScope() : (object instanceof CoordinateOperation ? ((CoordinateOperation)object).getScope() : null));
        return description != null ? description.toString(this.getJavaLocale()) : Referencing.emptyString();
    }

    public String getValidArea(XPropertySet xOptions, String authorityCode) {
        Extent validArea;
        try {
            validArea = this.crsFactory().createCoordinateReferenceSystem(authorityCode).getValidArea();
        }
        catch (Exception exception) {
            try {
                validArea = FactoryFinder.getCoordinateOperationAuthorityFactory(AUTHORITY, null).createCoordinateOperation(authorityCode).getValidArea();
            }
            catch (Exception ignore) {
                return Referencing.getLocalizedMessage(exception);
            }
        }
        if (validArea != null) {
            InternationalString description = validArea.getDescription();
            if (description != null) {
                return description.toString(this.getJavaLocale());
            }
            GeographicBoundingBox box = ExtentImpl.getGeographicBoundingBox(validArea);
            if (box != null) {
                return box.toString();
            }
        }
        return Referencing.emptyString();
    }

    public double[][] getBoundingBox(XPropertySet xOptions, String authorityCode) {
        Extent validArea;
        try {
            validArea = this.crsFactory().createCoordinateReferenceSystem(authorityCode).getValidArea();
        }
        catch (Exception exception) {
            try {
                validArea = FactoryFinder.getCoordinateOperationAuthorityFactory(AUTHORITY, null).createCoordinateOperation(authorityCode).getValidArea();
            }
            catch (Exception ignore) {
                this.reportException("getBoundingBox", exception);
                return Referencing.getFailure(4, 4);
            }
        }
        GeographicBoundingBox box = ExtentImpl.getGeographicBoundingBox(validArea);
        if (box == null) {
            return Referencing.getFailure(4, 4);
        }
        return new double[][]{{box.getNorthBoundLatitude(), box.getWestBoundLongitude()}, {box.getSouthBoundLatitude(), box.getEastBoundLongitude()}};
    }

    public String getRemarks(XPropertySet xOptions, String authorityCode) {
        IdentifiedObject object;
        try {
            object = this.crsFactory().createObject(authorityCode);
        }
        catch (Exception exception) {
            return Referencing.getLocalizedMessage(exception);
        }
        InternationalString remarks = object.getRemarks();
        return remarks != null ? remarks.toString(this.getJavaLocale()) : Referencing.emptyString();
    }

    public String getAxis(XPropertySet xOptions, String authorityCode, int dimension) {
        CoordinateSystem cs;
        try {
            cs = this.crsFactory().createCoordinateReferenceSystem(authorityCode).getCoordinateSystem();
        }
        catch (Exception exception) {
            try {
                CoordinateSystem cs2 = FactoryFinder.getCSAuthorityFactory(AUTHORITY, null).createCoordinateSystem(authorityCode);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return Referencing.getLocalizedMessage(exception);
        }
        if (dimension >= 1 && dimension <= cs.getDimension()) {
            return cs.getAxis(dimension - 1).getName().getCode();
        }
        return Errors.format(56, new Integer(dimension));
    }

    public Object getParameter(XPropertySet xOptions, String authorityCode, String parameter) {
        IdentifiedObject object;
        try {
            object = this.crsFactory().createObject(authorityCode);
        }
        catch (FactoryException exception) {
            return Referencing.getLocalizedMessage(exception);
        }
        ParameterValueGroup parameters = object instanceof Operation ? ((Operation)object).getParameterValues() : (object instanceof GeneralDerivedCRS ? ((GeneralDerivedCRS)object).getConversionFromBase().getParameterValues() : ParameterGroup.EMPTY);
        try {
            return parameters.parameter(parameter).getValue();
        }
        catch (ParameterNotFoundException exception) {
            return Errors.format(133, parameter);
        }
        catch (RuntimeException exception) {
            return Referencing.getLocalizedMessage(exception);
        }
    }

    public String getWKT(XPropertySet xOptions, String authorityCode, Object authority) {
        try {
            return Referencing.toWKT(this.crsFactory().createObject(authorityCode), authority);
        }
        catch (Exception exception) {
            return Referencing.getLocalizedMessage(exception);
        }
    }

    public String getTransformWKT(XPropertySet xOptions, String sourceCRS, String targetCRS, Object authority) {
        try {
            return Referencing.toWKT(this.getCoordinateOperation("getTransformWKT", sourceCRS, targetCRS).getMathTransform(), authority);
        }
        catch (Exception exception) {
            return Referencing.getLocalizedMessage(exception);
        }
    }

    public double getAccuracy(XPropertySet xOptions, String sourceCRS, String targetCRS) {
        CoordinateOperation operation;
        try {
            operation = this.getCoordinateOperation("getAccuracy", sourceCRS, targetCRS);
        }
        catch (FactoryException exception) {
            this.reportException("getAccuracy", exception);
            return Double.NaN;
        }
        return AbstractCoordinateOperation.getAccuracy(operation);
    }

    public double[][] getTransformedCoordinates(XPropertySet xOptions, double[][] coordinates, String sourceCRS, String targetCRS) {
        CoordinateOperation operation;
        try {
            operation = this.getCoordinateOperation("getTransformedCoordinates", sourceCRS, targetCRS);
        }
        catch (FactoryException exception) {
            this.reportException("getTransformedCoordinates", exception);
            return Referencing.getFailure(coordinates.length, 2);
        }
        boolean failureReported = false;
        MathTransform mt = operation.getMathTransform();
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(mt.getSourceDimensions());
        GeneralDirectPosition targetPt = new GeneralDirectPosition(mt.getTargetDimensions());
        double[][] result = new double[coordinates.length][];
        for (int j = 0; j < coordinates.length; ++j) {
            DirectPosition pt;
            double[] coords = coordinates[j];
            if (coords == null) continue;
            int i = sourcePt.ordinates.length;
            while (--i >= 0) {
                sourcePt.ordinates[i] = i < coords.length ? coords[i] : 0.0;
            }
            try {
                pt = mt.transform((DirectPosition)sourcePt, (DirectPosition)targetPt);
            }
            catch (TransformException exception) {
                if (failureReported) continue;
                this.reportException("getTransformedCoordinates", exception);
                failureReported = true;
                continue;
            }
            coords = new double[pt.getDimension()];
            int i2 = coords.length;
            while (--i2 >= 0) {
                coords[i2] = pt.getOrdinate(i2);
            }
            result[j] = coords;
        }
        return result;
    }

    public double[][] getOrthodromicDistance(XPropertySet xOptions, double[][] source, double[][] target, Object CRS) {
        GeodeticCalculator calculator;
        try {
            calculator = this.getGeodeticCalculator(CRS);
        }
        catch (Exception exception) {
            this.reportException("getOrthodromicDistance", exception);
            return Referencing.getFailure(source.length, 2);
        }
        boolean failureReported = false;
        int dim = calculator.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(dim);
        GeneralDirectPosition targetPt = new GeneralDirectPosition(dim);
        double[][] result = new double[Referencing.getLength((Object[])source, (Object[])target)][];
        for (int j = 0; j < result.length; ++j) {
            double[] src = source[j % source.length];
            double[] dst = target[j % target.length];
            if (src == null || dst == null) continue;
            int i = dim;
            while (--i >= 0) {
                sourcePt.ordinates[i] = i < src.length ? src[i] : 0.0;
                targetPt.ordinates[i] = i < dst.length ? dst[i] : 0.0;
            }
            try {
                calculator.setAnchorPosition((Position)sourcePt);
                calculator.setDestinationPosition((Position)targetPt);
            }
            catch (TransformException exception) {
                if (failureReported) continue;
                this.reportException("getOrthodromicDistance", exception);
                failureReported = true;
                continue;
            }
            result[j] = new double[]{calculator.getOrthodromicDistance(), calculator.getAzimuth()};
        }
        return result;
    }

    public double[][] getOrthodromicForward(XPropertySet xOptions, double[][] source, double[][] displacement, Object CRS) {
        GeodeticCalculator calculator;
        try {
            calculator = this.getGeodeticCalculator(CRS);
        }
        catch (Exception exception) {
            this.reportException("getOrthodromicForward", exception);
            return Referencing.getFailure(source.length, 2);
        }
        boolean failureReported = false;
        int dim = calculator.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(dim);
        double[][] result = new double[Referencing.getLength((Object[])source, (Object[])displacement)][];
        for (int j = 0; j < result.length; ++j) {
            DirectPosition targetPt;
            double[] src = source[j % source.length];
            double[] mov = displacement[j % displacement.length];
            if (src == null || mov == null) continue;
            int i = dim;
            while (--i >= 0) {
                sourcePt.ordinates[i] = i < src.length ? src[i] : 0.0;
            }
            double distance = 0.0;
            double azimuth = 0.0;
            switch (mov.length) {
                default: {
                    azimuth = mov[1];
                }
                case 1: {
                    distance = mov[0];
                }
                case 0: 
            }
            try {
                calculator.setAnchorPosition((Position)sourcePt);
                calculator.setDirection(azimuth, distance);
                targetPt = calculator.getDestinationPosition();
            }
            catch (TransformException exception) {
                if (failureReported) continue;
                this.reportException("getOrthodromicForward", exception);
                failureReported = true;
                continue;
            }
            result[j] = targetPt.getCoordinates();
        }
        return result;
    }

    protected void finalize() throws Throwable {
        if (this.crsFactory instanceof AbstractAuthorityFactory) {
            try {
                ((AbstractAuthorityFactory)this.crsFactory).dispose();
                this.crsFactory = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

