/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geomedia;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.geomedia.GeoMediaConnectionParam;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;

public class GeoMediaConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.geomedia");
    private static Map mDataSources = new HashMap();
    private String mDriverClassName;
    private String mPoolKey;
    private GeoMediaConnectionParam[] mParams;
    private String mUsername = "";
    private String mPasswd = "";

    public GeoMediaConnectionFactory(String classname, String poolKey, GeoMediaConnectionParam[] params) {
        this.mDriverClassName = classname;
        this.mPoolKey = poolKey;
        this.mParams = params;
    }

    public ConnectionPool getConnectionPool(String user, String pass) throws SQLException {
        String poolKey = this.mPoolKey + ":" + user + ":" + pass;
        ConnectionPoolDataSource poolDataSource = (ConnectionPoolDataSource)mDataSources.get(poolKey);
        if (poolDataSource == null) {
            try {
                Class<?> driver = Class.forName(this.mDriverClassName);
                Constructor<?> constr = driver.getConstructor(new Class[0]);
                poolDataSource = (ConnectionPoolDataSource)constr.newInstance(new Object[0]);
                for (int i = 0; i < this.mParams.length; ++i) {
                    Method method = driver.getMethod(this.mParams[i].getMethodName(), this.mParams[i].getClassType());
                    Object ret = method.invoke((Object)poolDataSource, this.mParams[i].getParam());
                }
                mDataSources.put(poolKey, poolDataSource);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Driver " + this.mDriverClassName + " not found!");
            }
            catch (NoSuchMethodException e) {
                throw new SQLException("Driver does not support method" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new SQLException("Cannot create instance of " + this.mDriverClassName);
            }
            catch (IllegalAccessException e) {
                throw new SQLException("IllegalAccessException while instantiating connection pool for driver " + this.mDriverClassName);
            }
            catch (InvocationTargetException e) {
                throw new SQLException("IllegalAccessException while instantiating connection pool for driver " + this.mDriverClassName);
            }
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool(poolDataSource);
        return connectionPool;
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        return this.getConnectionPool(this.mUsername, this.mPasswd);
    }

    public void setLogin(String user, String pass) {
        this.mUsername = user;
        this.mPasswd = pass;
    }
}

