/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geomedia;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.geomedia.GFeatureType;
import org.geotools.data.geomedia.attributeio.GeoMediaAttributeIO;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;

public class GeoMediaDataStore
extends JDBCDataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.geomedia");
    private static final Map TYPE_MAPPINGS = new HashMap();
    private Hashtable mGFeatureCache = null;

    public GeoMediaDataStore(ConnectionPool connectionPool) throws IOException {
        super(connectionPool, new JDBCDataStoreConfig());
    }

    public void readMetadata() throws DataSourceException {
        if (this.mGFeatureCache == null) {
            this.mGFeatureCache = new Hashtable();
        }
        if (this.mGFeatureCache.size() > 0) {
            this.mGFeatureCache.clear();
        }
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                conn = this.getConnection(Transaction.AUTO_COMMIT);
                String sql = "SELECT featurename, geometrytype, primarygeometryfieldname, featuredescription FROM gfeatures";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    GFeatureType gFeature = new GFeatureType();
                    gFeature.setTypeName(rs.getString(1));
                    gFeature.setGeoMediaFeatureType(rs.getInt(2));
                    gFeature.setGeomColName(rs.getString(3));
                    gFeature.setDescription(rs.getString(4));
                    this.mGFeatureCache.put(gFeature.getTypeName().toUpperCase(), gFeature);
                }
                Object var7_8 = null;
            }
            catch (IOException e) {
                LOGGER.warning("IOException reading metadata: " + e.getMessage());
                throw new DataSourceException(e.getMessage());
            }
            catch (SQLException e) {
                LOGGER.warning("SQLException reading metadata: " + e.getMessage());
                throw new DataSourceException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            JDBCUtils.close(rs);
            JDBCUtils.close(stmt);
            JDBCUtils.close((Connection)conn, null, null);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)stmt);
        JDBCUtils.close((Connection)conn, null, null);
    }

    protected boolean allowTable(String tablename) {
        if (this.mGFeatureCache == null) {
            try {
                this.readMetadata();
            }
            catch (IOException e) {
                return false;
            }
        }
        boolean res = this.mGFeatureCache.containsKey(tablename.toUpperCase());
        return res;
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        try {
            int TABLE_NAME = 3;
            int COLUMN_NAME = 4;
            if (this.mGFeatureCache == null) {
                this.readMetadata();
            }
            String columnName = rs.getString(4);
            String tableName = rs.getString(3);
            GFeatureType gFeature = (GFeatureType)this.mGFeatureCache.get(tableName.toUpperCase());
            if (gFeature != null && columnName.compareToIgnoreCase(gFeature.getGeomColName()) == 0) {
                return AttributeTypeFactory.newAttributeType((String)columnName, (Class)Geometry.class);
            }
            if (columnName.startsWith("GDO_GEOMETRY")) {
                return null;
            }
            return super.buildAttributeType(rs);
        }
        catch (SQLException e) {
            throw new DataSourceException("Sql exception while parsing feature type", e);
        }
    }

    protected AttributeIO getGeometryAttributeIO(AttributeType type, QueryData queryData) throws IOException {
        return new GeoMediaAttributeIO();
    }

    static {
        TYPE_MAPPINGS.put("bigint", Long.class);
        TYPE_MAPPINGS.put("bigint identity", Long.class);
        TYPE_MAPPINGS.put("int", Integer.class);
        TYPE_MAPPINGS.put("int identity", Integer.class);
        TYPE_MAPPINGS.put("smallint", Integer.class);
        TYPE_MAPPINGS.put("smallint identity", Integer.class);
        TYPE_MAPPINGS.put("char", Byte.class);
        TYPE_MAPPINGS.put("decimal", Double.class);
        TYPE_MAPPINGS.put("float", Float.class);
        TYPE_MAPPINGS.put("money", Double.class);
        TYPE_MAPPINGS.put("numeric", Double.class);
        TYPE_MAPPINGS.put("real", Double.class);
        TYPE_MAPPINGS.put("varchar", String.class);
        TYPE_MAPPINGS.put("nvarchar", String.class);
        TYPE_MAPPINGS.put("nchar", String.class);
    }
}

