/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geomedia;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.geomedia.GeoMediaConnectionFactory;
import org.geotools.data.geomedia.GeoMediaConnectionParam;
import org.geotools.data.geomedia.GeoMediaDataStore;
import org.geotools.data.jdbc.ConnectionPool;

public class GeoMediaDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.geomedia");
    private GeoMediaConnectionParam[] mConnectionParams = null;
    static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "This must be 'geomedia'.", true);
    static final DataStoreFactorySpi.Param DBDRIVER = new DataStoreFactorySpi.Param("dbdriver", String.class, "Class name of a Type4 Javax DataSource database driver.", true);
    static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "The user name to log in with.", true);
    static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "The password.", true);
    static final DataStoreFactorySpi.Param DBKEY = new DataStoreFactorySpi.Param("databasePoolKey", String.class, "the port number on the host, usually 1433", true, "1433");
    static final DataStoreFactorySpi.Param[] PARAM_INFO = new DataStoreFactorySpi.Param[]{DBTYPE, DBDRIVER, USER, PASSWD};

    public void setConnectionParams(GeoMediaConnectionParam[] params) {
        this.mConnectionParams = params;
    }

    public GeoMediaConnectionParam[] getConnectionParams() {
        return this.mConnectionParams;
    }

    public boolean canProcess(Map params) {
        if (this.mConnectionParams == null) {
            return false;
        }
        return params.containsKey("dbtype") && params.get("dbtype").equals("geomedia") && params.containsKey("dbkey") && params.containsKey("dbdriver") && params.containsKey("user") && params.containsKey("passwd");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String databaseDriver = (String)DBDRIVER.lookUp(params);
        String databasePoolKey = (String)DBKEY.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        try {
            GeoMediaConnectionFactory factory = new GeoMediaConnectionFactory(databaseDriver, databasePoolKey, this.mConnectionParams);
            factory.setLogin(user, passwd);
            ConnectionPool pool = factory.getConnectionPool();
            GeoMediaDataStore dataStore = new GeoMediaDataStore(pool);
            return dataStore;
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage());
        }
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("GeoTools cannot create a new GeoMedia Database");
    }

    public String getDisplayName() {
        return "GeoMedia";
    }

    public String getDescription() {
        return "GeoMedia Spatial Database";
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return PARAM_INFO;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

