/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geomedia.attributeio;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.geomedia.attributeio.GeoMediaGeometryAdapter;
import org.geotools.data.geomedia.attributeio.GeoMediaGeometryTypeNotKnownException;
import org.geotools.data.geomedia.attributeio.GeoMediaUnsupportedGeometryTypeException;
import org.geotools.data.jdbc.attributeio.AttributeIO;

public class GeoMediaAttributeIO
implements AttributeIO {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.geomedia");
    private GeoMediaGeometryAdapter geometryAdapter = new GeoMediaGeometryAdapter();

    public Object read(ResultSet rs, int position) throws IOException {
        try {
            return this.geometryAdapter.deSerialize((byte[])rs.getObject(position));
        }
        catch (SQLException e) {
            String msg = "SQL Exception reading geometry column";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, e);
        }
        catch (GeoMediaGeometryTypeNotKnownException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, e);
        }
        catch (GeoMediaUnsupportedGeometryTypeException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            if (value == null) {
                rs.updateNull(position);
            } else {
                byte[] blob = this.geometryAdapter.serialize((Geometry)value);
                rs.updateObject(position, (Object)blob);
            }
        }
        catch (SQLException sqlException) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, sqlException);
        }
        catch (GeoMediaUnsupportedGeometryTypeException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                byte[] blob = this.geometryAdapter.serialize((Geometry)value);
                ps.setObject(position, blob);
            }
        }
        catch (SQLException sqlException) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqlException);
            throw new DataSourceException(msg, sqlException);
        }
        catch (GeoMediaUnsupportedGeometryTypeException e) {
            String msg = "Geometry Conversion type error";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataSourceException(msg, e);
        }
    }
}

