/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geomedia.attributeio;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.geotools.data.geomedia.attributeio.GeoMediaGeometryTypeNotKnownException;
import org.geotools.data.geomedia.attributeio.GeoMediaUnsupportedGeometryTypeException;

public class GeoMediaGeometryAdapter {
    private static String[] mGdoGuidStrings = new String[]{"0FD2FFC0-8CBC-11CF-ABDE-08003601B769", "0FD2FFC8-8CBC-11CF-ABDE-08003601B769", "0FD2FFC9-8CBC-11CF-ABDE-08003601B769", "0FD2FFC1-8CBC-11CF-ABDE-08003601B769", "0FD2FFC2-8CBC-11CF-ABDE-08003601B769", "0FD2FFC3-8CBC-11CF-ABDE-08003601B769", "0FD2FFC7-8CBC-11CF-ABDE-08003601B769", "0FD2FFC5-8CBC-11CF-ABDE-08003601B769", "0FD2FFC6-8CBC-11CF-ABDE-08003601B769", "0FD2FFCB-8CBC-11CF-ABDE-08003601B769", "0FD2FFCC-8CBC-11CF-ABDE-08003601B769", "0FD2FFCA-8CBC-11CF-ABDE-08003601B769"};
    private static int[] mGdoGuidByteArray = new int[]{210, 15, 188, 140, 207, 17, 171, 222, 8, 0, 54, 1, 183, 105};
    GeometryFactory mGeometryFactory = new GeometryFactory();
    private Hashtable mTypeMapping = new Hashtable();

    public GeoMediaGeometryAdapter() {
        this.mTypeMapping.put(new Integer(65472), Point.class);
        this.mTypeMapping.put(new Integer(65480), Point.class);
        this.mTypeMapping.put(new Integer(65481), Point.class);
        this.mTypeMapping.put(new Integer(65473), LineString.class);
        this.mTypeMapping.put(new Integer(65474), LineString.class);
        this.mTypeMapping.put(new Integer(65475), Polygon.class);
        this.mTypeMapping.put(new Integer(65479), Polygon.class);
        this.mTypeMapping.put(new Integer(65477), Polygon.class);
        this.mTypeMapping.put(new Integer(65478), GeometryCollection.class);
        this.mTypeMapping.put(new Integer(65484), MultiLineString.class);
        this.mTypeMapping.put(new Integer(65483), MultiPolygon.class);
    }

    public Geometry deSerialize(byte[] input) throws IOException, GeoMediaGeometryTypeNotKnownException, GeoMediaUnsupportedGeometryTypeException {
        Point geom = null;
        if (input == null) {
            return geom;
        }
        if (input.length < 40) {
            return geom;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(input.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(input);
        byteBuffer.position(0);
        int uidNum = byteBuffer.getShort() & 0xFFFF;
        int[] vals = new int[14];
        for (int i = 0; i < 14; ++i) {
            vals[i] = byteBuffer.get();
        }
        Class geomType = (Class)this.mTypeMapping.get(new Integer(uidNum));
        if (geomType == null) {
            throw new GeoMediaGeometryTypeNotKnownException();
        }
        if (geomType == Point.class) {
            geom = this.createPointGeometry(byteBuffer);
        } else if (geomType == LineString.class) {
            geom = this.createLineStringGeometry(uidNum, byteBuffer);
        } else if (geomType == MultiLineString.class) {
            geom = this.createMultiLineStringGeometry(uidNum, byteBuffer);
        } else if (geomType == Polygon.class) {
            geom = this.createPolygonGeometry(uidNum, byteBuffer);
        } else if (geomType == GeometryCollection.class) {
            geom = this.createGeometryCollectionGeometry(byteBuffer);
        } else if (geomType == MultiPolygon.class) {
            throw new GeoMediaUnsupportedGeometryTypeException();
        }
        return geom;
    }

    private void writeGUID(Geometry input, ByteBuffer binaryWriter) throws IOException {
        int guidFlag = 0;
        if (input instanceof Point) {
            guidFlag = 65472;
        } else if (input instanceof LineString) {
            guidFlag = 65474;
        } else if (input instanceof Polygon) {
            guidFlag = 65475;
        }
        binaryWriter.putShort((short)(guidFlag & 0xFFFF));
        for (int i = 0; i < mGdoGuidByteArray.length; ++i) {
            binaryWriter.put((byte)mGdoGuidByteArray[i]);
        }
    }

    public byte[] serialize(Geometry input) throws IOException, GeoMediaUnsupportedGeometryTypeException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(65535);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        if (input instanceof Point) {
            Point geom = (Point)input;
            Coordinate c = geom.getCoordinate();
            this.writeGUID(input, byteBuffer);
            byteBuffer.putDouble(c.x);
            byteBuffer.putDouble(c.y);
            byteBuffer.putDouble(0.0);
        } else if (input instanceof LineString) {
            LineString geom = (LineString)input;
            Coordinate[] coords = geom.getCoordinates();
            this.writeGUID(input, byteBuffer);
            byteBuffer.putInt(coords.length);
            for (int i = 0; i < coords.length; ++i) {
                byteBuffer.putDouble(coords[i].x);
                byteBuffer.putDouble(coords[i].y);
                byteBuffer.putDouble(0.0);
            }
        } else if (input instanceof MultiLineString) {
            MultiLineString geom = (MultiLineString)input;
            int numGeoms = geom.getNumGeometries();
            this.writeGUID(input, byteBuffer);
            byteBuffer.putInt(numGeoms);
            for (int i = 0; i < numGeoms; ++i) {
                byte[] b = this.serialize(geom.getGeometryN(i));
                byteBuffer.putInt(b.length);
                for (int j = 0; j < b.length; ++j) {
                    byteBuffer.put(b[j]);
                }
            }
        } else if (input instanceof Polygon) {
            Polygon geom = (Polygon)input;
            Coordinate[] coords = geom.getExteriorRing().getCoordinates();
            this.writeGUID(input, byteBuffer);
            byteBuffer.putInt(coords.length);
            for (int i = 0; i < coords.length; ++i) {
                byteBuffer.putDouble(coords[i].x);
                byteBuffer.putDouble(coords[i].y);
                byteBuffer.putDouble(0.0);
            }
        } else {
            throw new GeoMediaUnsupportedGeometryTypeException();
        }
        return byteBuffer.array();
    }

    private Point createPointGeometry(double x, double y) {
        return this.mGeometryFactory.createPoint(new Coordinate(x, y));
    }

    private Point createPointGeometry(ByteBuffer reader) throws IOException {
        return this.createPointGeometry(reader.getDouble(), reader.getDouble());
    }

    private LineString createLineStringGeometry(double[] elems) {
        CoordinateList list = new CoordinateList();
        if (elems.length != 0 && elems.length < 4) {
            return null;
        }
        if (elems.length % 2 != 0) {
            return null;
        }
        for (int i = 0; i < elems.length; i += 2) {
            list.add((Object)new Coordinate(elems[i], elems[i + 1]));
        }
        return this.mGeometryFactory.createLineString(CoordinateArrays.toCoordinateArray((Collection)list));
    }

    private LineString createLineStringGeometry(int guid, ByteBuffer reader) throws IOException {
        double[] a = null;
        if (guid == 65473) {
            a = new double[4];
            a[0] = reader.getDouble();
            a[1] = reader.getDouble();
            reader.getDouble();
            a[2] = reader.getDouble();
            a[3] = reader.getDouble();
        } else {
            int numOrdinates = reader.getInt();
            a = new double[numOrdinates * 2];
            for (int i = 0; i < numOrdinates; ++i) {
                a[2 * i] = reader.getDouble();
                a[2 * i + 1] = reader.getDouble();
                reader.getDouble();
            }
        }
        return this.createLineStringGeometry(a);
    }

    private MultiLineString createMultiLineStringGeometry(ArrayList lineStrings) {
        LineString[] array = new LineString[lineStrings.size()];
        for (int i = 0; i < lineStrings.size(); ++i) {
            array[i] = (LineString)lineStrings.get(i);
        }
        return this.mGeometryFactory.createMultiLineString(array);
    }

    private MultiLineString createMultiLineStringGeometry(int guid, ByteBuffer reader) throws IOException, GeoMediaUnsupportedGeometryTypeException, GeoMediaGeometryTypeNotKnownException {
        int numItems = reader.getInt();
        ArrayList<Geometry> array = new ArrayList<Geometry>();
        for (int i = 0; i < numItems; ++i) {
            int elemSize = reader.getInt();
            byte[] elem = new byte[elemSize];
            for (int j = 0; j < elemSize; ++j) {
                elem[j] = reader.get();
            }
            Geometry g = this.deSerialize(elem);
            array.add(g);
        }
        return this.createMultiLineStringGeometry(array);
    }

    private Polygon createPolygonGeometry(double[] elems) {
        CoordinateList list = new CoordinateList();
        if (elems.length != 0 && elems.length <= 6) {
            return null;
        }
        if (elems.length % 2 != 0) {
            return null;
        }
        for (int i = 0; i < elems.length; i += 2) {
            list.add((Object)new Coordinate(elems[i], elems[i + 1]));
        }
        LinearRing ring = this.mGeometryFactory.createLinearRing(CoordinateArrays.toCoordinateArray((Collection)list));
        return this.mGeometryFactory.createPolygon(ring, null);
    }

    private Polygon createPolygonGeometry(int guid, ByteBuffer reader) throws IOException {
        double[] a = null;
        if (guid == 65475) {
            int numOrdinates = reader.getInt();
            a = new double[numOrdinates * 2];
            for (int i = 0; i < numOrdinates; ++i) {
                a[2 * i] = reader.getDouble();
                a[2 * i + 1] = reader.getDouble();
                reader.getDouble();
            }
        } else if (guid == 65479) {
            double x = reader.getDouble();
            double y = reader.getDouble();
            double z = reader.getDouble();
            double w = reader.getDouble();
            double h = reader.getDouble();
            a = new double[]{x, y, x + w, y, x + w, y + h, x, y + h};
        }
        return this.createPolygonGeometry(a);
    }

    private GeometryCollection createGeometryCollectionGeometry(ByteBuffer reader) throws IOException, GeoMediaUnsupportedGeometryTypeException, GeoMediaGeometryTypeNotKnownException {
        int numItems = reader.getInt();
        ArrayList<Geometry> array = new ArrayList<Geometry>();
        for (int i = 0; i < numItems; ++i) {
            int elemSize = reader.getInt();
            byte[] elem = new byte[elemSize];
            for (int j = 0; j < elemSize; ++j) {
                elem[j] = reader.get();
            }
            Geometry g = this.deSerialize(elem);
            if (g == null) continue;
            array.add(g);
        }
        return this.createGeometryCollectionGeometry(array);
    }

    private GeometryCollection createGeometryCollectionGeometry(ArrayList geoms) {
        Geometry[] array = new Geometry[geoms.size()];
        for (int i = 0; i < geoms.size(); ++i) {
            array[i] = (Geometry)geoms.get(i);
        }
        return this.mGeometryFactory.createGeometryCollection(array);
    }
}

