/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hsql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class HsqlConnectionFactory {
    private static final String DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private String _username = "";
    private String _password = "";
    private String charSet;
    private String _dbFileName = null;

    public HsqlConnectionFactory(String dbFileName, String user, String password) {
        this._dbFileName = dbFileName;
        this._username = user;
        this._password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this._dbFileName, this._username, this._password);
    }

    public Connection getConnection(String dbFileName) throws SQLException {
        this._dbFileName = dbFileName;
        return this.getConnection(this._dbFileName, this._username, this._password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        this.setLogin(username, password);
        return this.getConnection(this._dbFileName, username, password);
    }

    public Connection getConnection(String dbFileName, String user, String password) throws SQLException {
        this._dbFileName = dbFileName;
        this._username = user;
        this._password = password;
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        if (this.charSet != null) {
            props.put("charSet", this.charSet);
        }
        return this.getConnection(dbFileName, props);
    }

    public Connection getConnection(String dbFileName, Properties props) throws SQLException {
        this._dbFileName = dbFileName;
        Connection dbConnection = null;
        try {
            Class.forName(DRIVER_CLASS);
            dbConnection = DriverManager.getConnection("jdbc:hsqldb:" + dbFileName, props);
            this.setSpatialAliases(dbConnection);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dbConnection;
    }

    public void setLogin(String username, String password) {
        this._username = username;
        this._password = password;
    }

    public void setDBFileName(String dbFileName) {
        this._dbFileName = dbFileName;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    private void setSpatialAliases(Connection conn) throws IOException, SQLException {
        Statement st = conn.createStatement();
        st.execute("CREATE ALIAS equals FOR \"org.openplans.spatialDBbox.StaticGeometry.equals\";CREATE ALIAS toString FOR \"org.openplans.spatialDBbox.StaticGeometry.toString\";CREATE ALIAS contains FOR \"org.openplans.spatialDBbox.StaticGeometry.contains\";CREATE ALIAS isEmpty FOR \"org.openplans.spatialDBbox.StaticGeometry.isEmpty\";CREATE ALIAS length FOR \"org.openplans.spatialDBbox.StaticGeometry.getLength\";CREATE ALIAS intersects FOR \"org.openplans.spatialDBbox.StaticGeometry.intersects\";CREATE ALIAS geomFromWKT FOR \"org.openplans.spatialDBbox.StaticGeometry.geomFromWKT\";CREATE ALIAS isValid FOR \"org.openplans.spatialDBbox.StaticGeometry.isValid\";CREATE ALIAS geometryType FOR \"org.openplans.spatialDBbox.StaticGeometry.getGeometryType\";CREATE ALIAS sRID FOR \"org.openplans.spatialDBbox.StaticGeometry.getSRID\";CREATE ALIAS numPoints FOR \"org.openplans.spatialDBbox.StaticGeometry.getNumPoints\";CREATE ALIAS isSimple FOR \"org.openplans.spatialDBbox.StaticGeometry.isSimple\";CREATE ALIAS distance FOR \"org.openplans.spatialDBbox.StaticGeometry.distance\";CREATE ALIAS isWithinDistance FOR \"org.openplans.spatialDBbox.StaticGeometry.isWithinDistance\";CREATE ALIAS area FOR \"org.openplans.spatialDBbox.StaticGeometry.getArea\";CREATE ALIAS centroid FOR \"org.openplans.spatialDBbox.StaticGeometry.getCentroid\";CREATE ALIAS interiorPoint FOR \"org.openplans.spatialDBbox.StaticGeometry.getInteriorPoint\";CREATE ALIAS dimension FOR \"org.openplans.spatialDBbox.StaticGeometry.getDimension\";CREATE ALIAS boundary FOR \"org.openplans.spatialDBbox.StaticGeometry.getBoundary\";CREATE ALIAS boundaryDimension FOR \"org.openplans.spatialDBbox.StaticGeometry.getBoundaryDimension\";CREATE ALIAS envelope FOR \"org.openplans.spatialDBbox.StaticGeometry.getEnvelope\";CREATE ALIAS disjoint FOR \"org.openplans.spatialDBbox.StaticGeometry.disjoint\";CREATE ALIAS touches FOR \"org.openplans.spatialDBbox.StaticGeometry.touches\";CREATE ALIAS crosses FOR \"org.openplans.spatialDBbox.StaticGeometry.crosses\";CREATE ALIAS within FOR \"org.openplans.spatialDBbox.StaticGeometry.within\";CREATE ALIAS overlaps FOR \"org.openplans.spatialDBbox.StaticGeometry.overlaps\";CREATE ALIAS relatePattern FOR \"org.openplans.spatialDBbox.StaticGeometry.relatePattern\";CREATE ALIAS relate FOR \"org.openplans.spatialDBbox.StaticGeometry.relate\";CREATE ALIAS toText FOR \"org.openplans.spatialDBbox.StaticGeometry.toText\";CREATE ALIAS buffer_with_segments FOR \"org.openplans.spatialDBbox.StaticGeometry.buffer_with_segments\";CREATE ALIAS buffer FOR \"org.openplans.spatialDBbox.StaticGeometry.buffer\";CREATE ALIAS convexHull FOR \"org.openplans.spatialDBbox.StaticGeometry.convexHull\";CREATE ALIAS intersection FOR \"org.openplans.spatialDBbox.StaticGeometry.intersection\";CREATE ALIAS unionGeom FOR \"org.openplans.spatialDBbox.StaticGeometry.unionGeom\";CREATE ALIAS difference FOR \"org.openplans.spatialDBbox.StaticGeometry.difference\";CREATE ALIAS symDifference FOR \"org.openplans.spatialDBbox.StaticGeometry.symDifference\";CREATE ALIAS equalsExactTolerance FOR \"org.openplans.spatialDBbox.StaticGeometry.equalsExactTolerance\";CREATE ALIAS equalsExact FOR \"org.openplans.spatialDBbox.StaticGeometry.equalsExact\";CREATE ALIAS numGeometries FOR \"org.openplans.spatialDBbox.StaticGeometry.getNumGeometries\";CREATE ALIAS geometryN FOR \"org.openplans.spatialDBbox.StaticGeometry.getGeometryN\";CREATE ALIAS x FOR \"org.openplans.spatialDBbox.StaticGeometry.getX\";CREATE ALIAS y FOR \"org.openplans.spatialDBbox.StaticGeometry.getY\";CREATE ALIAS isClosed FOR \"org.openplans.spatialDBbox.StaticGeometry.isClosed\";CREATE ALIAS pointN FOR \"org.openplans.spatialDBbox.StaticGeometry.getPointN\";CREATE ALIAS startPoint FOR \"org.openplans.spatialDBbox.StaticGeometry.getStartPoint\";CREATE ALIAS endPoint FOR \"org.openplans.spatialDBbox.StaticGeometry.getEndPoint\";CREATE ALIAS isRing FOR \"org.openplans.spatialDBbox.StaticGeometry.isRing\";CREATE ALIAS exteriorRing FOR \"org.openplans.spatialDBbox.StaticGeometry.getExteriorRing\";CREATE ALIAS numInteriorRing FOR \"org.openplans.spatialDBbox.StaticGeometry.getNumInteriorRing\";CREATE ALIAS interiorRingN FOR \"org.openplans.spatialDBbox.StaticGeometry.getInteriorRingN\";");
    }
}

