/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hsql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.hsql.HsqlConnectionFactory;
import org.geotools.data.hsql.HsqlFeatureWriter;
import org.geotools.data.hsql.HsqlSQLBuilder;
import org.geotools.data.hsql.HsqlTransactionStateDiff;
import org.geotools.data.hsql.fidmapper.HsqlFIDMapperFactory;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.WKTAttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderHsql;

public class HsqlDataStore
extends JDBC1DataStore
implements DataStore {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.hsql");
    private Connection connection;
    private HsqlConnectionFactory hsqlConnFactory;
    private boolean typeTableExists;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public HsqlDataStore(HsqlConnectionFactory connectionFactory) throws IOException {
        this(connectionFactory, null);
    }

    protected boolean requireAutoCommit() {
        return true;
    }

    public HsqlDataStore(HsqlConnectionFactory connectionFactory, String databaseSchemaName) throws IOException {
        this(connectionFactory, databaseSchemaName, null);
    }

    public HsqlDataStore(HsqlConnectionFactory connectionFactory, String databaseSchemaName, String namespace) throws IOException {
        super(JDBCDataStoreConfig.createWithNameSpaceAndSchemaName((String)namespace, (String)databaseSchemaName));
        this.hsqlConnFactory = connectionFactory;
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        FeatureType featureType = this.getSchema(typeName);
        return this.getFeatureReader(featureType, Filter.NONE, Transaction.AUTO_COMMIT);
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        FeatureReader reader = super.getFeatureReader(query, transaction);
        if (transaction != Transaction.AUTO_COMMIT) {
            String typeName = query.getTypeName();
            Diff diff = this.state(transaction).diff(typeName);
            reader = new DiffFeatureReader(reader, diff);
        }
        if (query.getFilter() != null && query.getFilter() != Filter.NONE) {
            reader = new FilteringFeatureReader(reader, query.getFilter());
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HsqlTransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            HsqlTransactionStateDiff state = (HsqlTransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                try {
                    state = new HsqlTransactionStateDiff(this, this.createConnection());
                    transaction.putState((Object)this, (Transaction.State)state);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return state;
        }
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new HsqlFIDMapperFactory();
    }

    public void addFeatures(final Feature[] features) throws IOException {
        if (features.length == 0) {
            return;
        }
        FeatureReader reader = new FeatureReader(){
            int i = 0;

            public FeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                Feature f = features[this.i];
                ++this.i;
                return f;
            }

            public boolean hasNext() throws IOException {
                return this.i < features.length;
            }

            public void close() throws IOException {
            }
        };
        FeatureStore fs = (FeatureStore)this.getFeatureSource(features[0].getFeatureType().getTypeName());
        fs.addFeatures(reader);
    }

    public FeatureWriter getFeatureWriter(String typeName) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureWriter writer = transaction == Transaction.AUTO_COMMIT ? super.getFeatureWriter(typeName, filter, transaction) : this.state(transaction).writer(typeName, filter);
        return writer;
    }

    public FeatureWriter getFeatureWriterAppend(String typeName) throws IOException {
        return this.getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        int COLUMN_NAME = 4;
        int TABLE_NAME = 3;
        try {
            String tableName = rs.getString(3);
            String type = this.findType(tableName, rs.getString(4));
            return AttributeTypeFactory.newAttributeType((String)rs.getString(4), Class.forName(type));
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return super.buildAttributeType(rs);
        }
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoderHsql encoder = new SQLEncoderHsql();
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new HsqlSQLBuilder(encoder, this.getSchema(typeName));
    }

    protected AttributeIO getGeometryAttributeIO(AttributeType type, QueryData queryData) {
        return new WKTAttributeIO();
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        return new HsqlFeatureWriter(reader, queryData);
    }

    protected Connection createConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed() && this.hsqlConnFactory != null) {
            this.connection = this.hsqlConnFactory.getConnection();
            return this.connection;
        }
        return this.connection;
    }

    protected Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            HsqlTransactionStateDiff state = (HsqlTransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                try {
                    state = new HsqlTransactionStateDiff(this, this.createConnection());
                    transaction.putState((Object)this, (Transaction.State)state);
                }
                catch (SQLException eep) {
                    throw new DataSourceException("Connection failed:" + eep, (Throwable)eep);
                }
            }
            return state.getConnection();
        }
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return this.createConnection();
            }
            return this.connection;
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Connection failed:" + sqle, (Throwable)sqle);
        }
    }

    public void createSchema(FeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        String namespace = featureType.getNamespace().toString();
        String colName = null;
        Class colClass = null;
        String colType = null;
        AttributeType[] atts = featureType.getAttributeTypes();
        try {
            this.createConnection();
            Statement st = this.connection.createStatement();
            String sql = "CREATE CACHED TABLE " + typeName + "( ";
            sql = sql + "_FID INTEGER IDENTITY";
            this.addTypeTable(typeName, namespace, "_FID", "java.lang.Integer");
            for (int i = 0; i < atts.length; ++i) {
                sql = sql + ",";
                colName = atts[i].getName();
                colClass = atts[i].getType();
                if (colClass.isAssignableFrom(Integer.TYPE) || colClass.isAssignableFrom(class$java$lang$Integer == null ? HsqlDataStore.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    colType = "integer";
                } else if (colClass.isAssignableFrom(class$java$lang$String == null ? HsqlDataStore.class$("java.lang.String") : class$java$lang$String)) {
                    colType = "varchar";
                } else if (colClass.isAssignableFrom(Double.TYPE) || colClass.isAssignableFrom(class$java$lang$Double == null ? HsqlDataStore.class$("java.lang.Double") : class$java$lang$Double)) {
                    colType = "double";
                } else if (colClass.isAssignableFrom(class$com$vividsolutions$jts$geom$Geometry == null ? HsqlDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry)) {
                    colType = "varchar";
                } else if ((class$com$vividsolutions$jts$geom$Geometry == null ? HsqlDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(colClass)) {
                    colType = "varchar";
                }
                sql = sql + " " + colName + " " + colType;
                this.addTypeTable(typeName, namespace, atts[i]);
            }
            sql = sql + " )";
            st.execute(sql);
            this.typeHandler.forceRefresh();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("Attempted to re-create typeTable table...OK");
        }
    }

    protected boolean allowTable(String tablename) {
        return !tablename.equalsIgnoreCase("TYPETABLE");
    }

    public void removeSchema(FeatureType featureType) {
        String typeName = featureType.getTypeName();
        try {
            this.createConnection();
            Statement st = this.connection.createStatement();
            String sql = "DROP TABLE " + typeName;
            st.execute(sql);
        }
        catch (SQLException e) {
            LOGGER.fine("Table does not exist.");
        }
    }

    private String findType(String typeName, String columnName) {
        try {
            if (this.connection == null) {
                this.createConnection();
            }
            Statement st = this.connection.createStatement();
            String sql = "SELECT typeName, columnName, class FROM typeTable WHERE TYPENAME = '" + typeName + "' AND COLUMNNAME = '" + columnName + "'";
            ResultSet rs = st.executeQuery(sql);
            rs.next();
            String type = rs.getString(3);
            return type;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void addTypeTable(String typeName, String namespace, AttributeType attribute) {
        this.addTypeTable(typeName, namespace, attribute.getName().toUpperCase(), attribute.getType().getName());
    }

    private void addTypeTable(String typeName, String namespace, String name, String type) {
        try {
            if (this.connection == null) {
                this.createConnection();
            }
            this.createTypeTable();
            Statement st = this.connection.createStatement();
            String sql = "INSERT INTO typeTable (typeName, namespace, columnName, class) VALUES( '" + typeName.toUpperCase() + "', " + "'" + namespace + "', " + "'" + name + "', " + "'" + type + "'" + ")";
            st.execute(sql);
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void createTypeTable() {
        if (this.typeTableExists) {
            return;
        }
        try {
            if (this.connection == null) {
                this.createConnection();
            }
            this.typeTableExists = true;
            Statement st = this.connection.createStatement();
            String sql = "CREATE CACHED TABLE typeTable( typeName varchar, namespace varchar, columnName varchar, class varchar, encoding varchar, srid integer, PRIMARY KEY(typeName, namespace, columnName))";
            st.execute(sql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setAutoCommit(boolean arg0, Connection arg1) throws SQLException {
    }
}

