/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hsql;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.hsql.HsqlConnectionFactory;
import org.geotools.data.hsql.HsqlDataStore;

public class HsqlDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger(HsqlDataStoreFactory.class.getName());
    private static final String DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    public static final DataStoreFactorySpi.Param DBTYPE = new DataStoreFactorySpi.Param("dbtype", String.class, "must be 'hsql'", true, (Object)"hsql");
    public static final DataStoreFactorySpi.Param HOST = new DataStoreFactorySpi.Param("host", String.class, "hsql host machine", true, (Object)"localhost");
    public static final DataStoreFactorySpi.Param PORT = new DataStoreFactorySpi.Param("port", String.class, "hsql connection port", true, (Object)"9001");
    public static final DataStoreFactorySpi.Param DATABASE = new DataStoreFactorySpi.Param("database", String.class, "hsql database");
    public static final DataStoreFactorySpi.Param DBFILENAME = new DataStoreFactorySpi.Param("hsqlfilename", String.class, "hsql database filename");
    public static final DataStoreFactorySpi.Param USER = new DataStoreFactorySpi.Param("user", String.class, "user name to login as", false);
    public static final DataStoreFactorySpi.Param PASSWD = new DataStoreFactorySpi.Param("passwd", String.class, "password used to login", false);
    public static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "namespace prefix used", false);
    public static final DataStoreFactorySpi.Param[] arrayParameters = new DataStoreFactorySpi.Param[]{DBTYPE, DBFILENAME, USER, PASSWD, NAMESPACE};
    private static Map datastores = Collections.synchronizedMap(new HashMap());

    public boolean canProcess(Map params) {
        if (params != null) {
            for (int i = 0; i < arrayParameters.length; ++i) {
                Object value = params.get(HsqlDataStoreFactory.arrayParameters[i].key);
                if (value != null && HsqlDataStoreFactory.arrayParameters[i].type.isInstance(value) || !HsqlDataStoreFactory.arrayParameters[i].required) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.warning("Failed on : " + HsqlDataStoreFactory.arrayParameters[i].key);
                    LOGGER.fine(params.toString());
                }
                return false;
            }
        } else {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("hsql");
    }

    public DataStore createDataStore(Map params) throws IOException {
        if (datastores.containsKey(params)) {
            return (DataStore)datastores.get(params);
        }
        return this.createNewDataStore(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        String filename = (String)DBFILENAME.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (!this.canProcess(params)) {
            LOGGER.warning("Can not process : " + params);
            throw new IOException("The parameteres map isn't correct!!");
        }
        HsqlConnectionFactory connFact = new HsqlConnectionFactory(filename, user, passwd);
        HsqlDataStore ds = namespace != null ? new HsqlDataStore(connFact, namespace) : new HsqlDataStore(connFact);
        datastores.put(params, ds);
        return ds;
    }

    public String getDisplayName() {
        return "HSQL";
    }

    public String getDescription() {
        return "HSQL Database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warning("HSQL data sources are not available: " + cnfe.getMessage());
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DBTYPE, DBFILENAME, USER, PASSWD, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

