/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hsql;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.hsql.HsqlDataStore;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.filter.Filter;

public class HsqlTransactionStateDiff
extends JDBCTransactionState
implements Transaction.State {
    HsqlDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();

    public HsqlTransactionStateDiff(HsqlDataStore dataStore, Connection connection) throws IOException {
        super(connection);
        this.store = dataStore;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.typeNameDiff != null) {
                Iterator i = this.typeNameDiff.values().iterator();
                while (i.hasNext()) {
                    Diff diff = (Diff)i.next();
                    diff.clear();
                }
                this.typeNameDiff.clear();
            }
            this.store = null;
        }
    }

    public synchronized Diff diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return (Diff)this.typeNameDiff.get(typeName);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types;
        try {
            types = this.store.getTypeNames();
        }
        catch (IOException e) {
            return false;
        }
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            this.applyDiff(typeName, diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDiff(String typeName, Diff diff) throws IOException {
        FeatureWriter writer;
        if (diff.isEmpty()) {
            return;
        }
        try {
            writer = this.store.getFeatureWriter(typeName);
        }
        catch (UnsupportedOperationException e) {
            writer = this.store.getFeatureWriter(typeName);
        }
        try {
            String fid;
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                fid = feature.getID();
                if (!diff.modified2.containsKey(fid)) continue;
                Feature update = (Feature)diff.modified2.get(fid);
                if (update == TransactionStateDiff.NULL) {
                    writer.remove();
                    this.store.listenerManager.fireFeaturesRemoved(typeName, this.transaction, feature.getBounds(), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes(null));
                    writer.write();
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude(feature.getBounds());
                    bounds.expandToInclude(update.getBounds());
                    this.store.listenerManager.fireFeaturesChanged(typeName, this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                }
            }
            Iterator i = diff.added.values().iterator();
            while (i.hasNext()) {
                Feature addedFeature = (Feature)i.next();
                fid = addedFeature.getID();
                SimpleFeature nextFeature = (SimpleFeature)writer.next();
                if (nextFeature == null) {
                    throw new DataSourceException("Could not add " + fid);
                }
                try {
                    nextFeature.setAttributes(addedFeature.getAttributes(null));
                    writer.write();
                    this.store.listenerManager.fireFeaturesAdded(typeName, this.transaction, nextFeature.getBounds(), true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                }
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            writer.close();
            this.store.listenerManager.fireChanged(typeName, this.transaction, true);
            diff.clear();
            throw throwable;
        }
        writer.close();
        this.store.listenerManager.fireChanged(typeName, this.transaction, true);
        diff.clear();
    }

    public synchronized void rollback() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            diff.clear();
            this.store.listenerManager.fireChanged(typeName, this.transaction, false);
        }
    }

    public synchronized FeatureReader reader(String typeName) throws IOException {
        Diff diff = this.diff(typeName);
        FeatureReader reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureReader(reader, diff);
    }

    public synchronized FeatureWriter writer(final String typeName, Filter filter) throws IOException {
        Diff diff = this.diff(typeName);
        FeatureType schema = this.store.getSchema(typeName);
        FeatureReader reader = this.store.getFeatureReader(schema, filter, this.transaction);
        return new DiffFeatureWriter(reader, diff){

            public void fireNotification(int eventType, Envelope bounds) {
                switch (eventType) {
                    case 1: {
                        HsqlTransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, HsqlTransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        HsqlTransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, HsqlTransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        HsqlTransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, HsqlTransactionStateDiff.this.transaction, bounds, false);
                    }
                }
            }
        };
    }

    public Connection getConnection() {
        try {
            return this.store.createConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
}

