/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hsql.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import org.geotools.data.hsql.fidmapper.HsqlFIDMapper;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;

public class HsqlFIDMapperFactory
extends DefaultFIDMapperFactory {
    public FIDMapper getMapper(String catalog, String schema, String tableName, Connection connection) throws IOException {
        DefaultFIDMapperFactory.ColumnInfo[] colInfos = this.getPkColumnInfo(catalog, schema, tableName, connection);
        FIDMapper mapper = null;
        if (colInfos.length == 0) {
            mapper = this.buildNoPKMapper(schema, tableName, connection);
        } else if (colInfos.length > 1) {
            mapper = this.buildMultiColumnFIDMapper(schema, tableName, connection, colInfos);
        } else {
            DefaultFIDMapperFactory.ColumnInfo ci = colInfos[0];
            mapper = this.buildSingleColumnFidMapper(schema, tableName, connection, ci);
        }
        if (mapper == null && (mapper = this.buildLastResortFidMapper(schema, tableName, connection, colInfos)) == null) {
            throw new IOException("Cannot map primary key to a FID mapper, primary key columns are:\n" + this.getColumnInfoList(colInfos));
        }
        return new HsqlFIDMapper(mapper, tableName);
    }
}

