/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;

public class SQLEncoderHsql
extends SQLEncoder
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private static WKTWriter wkt = new WKTWriter();
    private int srid;
    private String defaultGeom;
    private static final String SQL_WILD_MULTI = "%";
    private static final String SQL_WILD_SINGLE = "_";
    private String escapedWildcardMulti = "\\.\\*";
    private String escapedWildcardSingle = "\\.\\?";

    public SQLEncoderHsql() {
        this.capabilities = this.createFilterCapabilities();
        this.setSqlNameEscape("");
    }

    public SQLEncoderHsql(int srid) {
        this.srid = srid;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x2000000L);
        capabilities.addType(0x800000L);
        capabilities.addType(0x1000000L);
        capabilities.addType(65536L);
        capabilities.addType(0x200000L);
        capabilities.addType(524288L);
        capabilities.addType(131072L);
        capabilities.addType(0x100000L);
        capabilities.addType(262144L);
        capabilities.addType(8192L);
        capabilities.addType(4096L);
        capabilities.addType(0x40000000L);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(1L);
        capabilities.addType(0x400000L);
        capabilities.addType(2048L);
        return capabilities;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setDefaultGeometry(String name) {
        this.defaultGeom = name;
    }

    public void visit(GeometryFilter filter) throws RuntimeException {
        LOGGER.finer("exporting GeometryFilter");
        System.out.println("exporting GeometryFilter");
        if (filter.getFilterType() == 4) {
            DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
            DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
            try {
                this.out.write("intersects(");
                if (left == null) {
                    this.out.write(this.defaultGeom);
                } else {
                    left.accept((FilterVisitor)this);
                }
                this.out.write(", ");
                if (right == null) {
                    this.out.write(this.defaultGeom);
                } else {
                    right.accept((FilterVisitor)this);
                }
                this.out.write(")");
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
            }
        } else {
            LOGGER.warning("exporting unknown filter type, only bbox supported");
            throw new RuntimeException("Only BBox is currently supported");
        }
    }

    public void visitLiteralGeometry(LiteralExpression expression) throws IOException {
        Geometry bbox = (Geometry)expression.getLiteral();
        String geomText = wkt.write(bbox);
        this.out.write("GeomFromWKT('" + geomText + "')");
    }

    public void visit(LikeFilter filter) {
        try {
            String pattern = filter.getPattern();
            pattern = pattern.replaceAll(this.escapedWildcardMulti, SQL_WILD_MULTI);
            pattern = pattern.replaceAll(this.escapedWildcardSingle, SQL_WILD_SINGLE);
            this.out.write("UPPER(");
            filter.getValue().accept((FilterVisitor)this);
            this.out.write(") LIKE ");
            this.out.write("UPPER('" + pattern + "')");
            String esc = filter.getEscape();
            if (pattern.indexOf(esc) != -1) {
                this.out.write(" ESCAPE '" + esc + "'");
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }
}

