/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.filter.v1_0.OGC;
import org.geotools.xml.ComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;
import org.picocontainer.MutablePicoContainer;

public class OGCLiteralTypeBinding
implements ComplexBinding {
    private FilterFactory factory;

    public OGCLiteralTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return OGC.LITERALTYPE;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Literal.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (!node.getChildren().isEmpty()) {
            return this.factory.literal(node.getChildValue(0));
        }
        return this.factory.literal(this.convert(value));
    }

    Object convert(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                int number = Integer.parseInt(string);
                return new Integer(number);
            }
            catch (NumberFormatException ex) {
                try {
                    double number = Double.parseDouble(string);
                    return new Double(number);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return value;
    }
}

