/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.model;

import java.util.Comparator;
import java.util.Iterator;
import org.geowidgets.framework.Res;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPSGEntry
implements Comparable<EPSGEntry> {
    public static final String OTHER_NAME = Res.get(Res.CRS, "x.Custom");
    public static final EPSGEntry OTHER = new EPSGEntry(" --- ", OTHER_NAME, true);
    protected final String codeString;
    protected final Integer code;
    protected String name;
    protected boolean isCustom = false;
    protected boolean isOther = false;
    public static final Comparator<EPSGEntry> COMPARE_NAME = new NameComparator();
    public static final Comparator<EPSGEntry> COMPARE_CODE = new CodeComparator();

    public static EPSGEntry getEntryFor(IdentifiedObject o) {
        String name = o.getName().getCode();
        Iterator it = o.getIdentifiers().iterator();
        if (!it.hasNext()) {
            return new EPSGEntry(name);
        }
        return new EPSGEntry(((Identifier)it.next()).getCode(), name);
    }

    public EPSGEntry(String name) {
        this.name = name;
        this.codeString = null;
        this.code = new Integer(-1);
        this.isCustom = true;
    }

    public EPSGEntry(String code, AuthorityFactory factory) {
        this.codeString = code;
        this.code = new Integer(code);
        try {
            this.name = factory.getDescriptionText(code).toString();
        }
        catch (FactoryException e) {
            this.name = e.getLocalizedMessage();
        }
    }

    public EPSGEntry(String code, String name) {
        this.codeString = code;
        this.code = new Integer(code);
        this.name = name;
    }

    public EPSGEntry(String code, String name, boolean isOther) {
        this.codeString = code;
        this.code = isOther ? new Integer(-1) : new Integer(code);
        this.name = name;
        this.isOther = isOther;
        this.isCustom = isOther;
    }

    public String getCode() {
        return this.codeString;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isOther() {
        return this.isOther;
    }

    @Override
    public int compareTo(EPSGEntry entry) {
        return COMPARE_NAME.compare(this, entry);
    }

    public boolean equals(Object o) {
        try {
            EPSGEntry entry = (EPSGEntry)o;
            return this.codeString.equals(entry.codeString);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparator
    implements Comparator<EPSGEntry> {
        @Override
        public int compare(EPSGEntry entry1, EPSGEntry entry2) {
            if (entry1.isOther && entry2.isOther) {
                return 0;
            }
            if (entry1.isOther) {
                return -1;
            }
            if (entry2.isOther) {
                return 1;
            }
            return entry1.name.compareTo(entry2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CodeComparator
    implements Comparator<EPSGEntry> {
        @Override
        public int compare(EPSGEntry entry1, EPSGEntry entry2) {
            if (entry1.isOther && entry2.isOther) {
                return 0;
            }
            if (entry1.isOther) {
                return -1;
            }
            if (entry2.isOther) {
                return 1;
            }
            return entry1.code.compareTo(entry2.code);
        }
    }
}

