/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.units.Unit;
import org.MaBaUtils.C;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.FactoryGroup;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.model.ICRSModel;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.Util;
import org.geowidgets.framework.ui.GeneralUIFactory;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoTools_CRSModel
implements ICRSModel {
    protected static final Logger LOGGER = GWFactoryFinder.getLoggerFactory().getLogger();
    protected static final GeneralUIFactory UI = GWFactoryFinder.getGeneralUIFactory();
    protected final boolean checkBeforeInsert = false;
    DatumAuthorityFactory dAFactory = FactoryFinder.getDatumAuthorityFactory((String)"EPSG", null);
    CSAuthorityFactory csAFactory = FactoryFinder.getCSAuthorityFactory((String)"EPSG", null);
    CRSAuthorityFactory crsAFactory = FactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
    CoordinateOperationAuthorityFactory opAFactory = FactoryFinder.getCoordinateOperationAuthorityFactory((String)"EPSG", null);
    DatumFactory dFactory = FactoryFinder.getDatumFactory(null);
    CSFactory csFactory = FactoryFinder.getCSFactory(null);
    CRSFactory crsFactory = FactoryFinder.getCRSFactory(null);
    CoordinateOperationFactory opFactory = FactoryFinder.getCoordinateOperationFactory(null);
    protected Map<Class, EPSGEntry> defaults2D = new HashMap<Class, EPSGEntry>();
    protected Map<Class, EPSGEntry> defaults3D = new HashMap<Class, EPSGEntry>();
    protected static ICRSModel me = new GeoTools_CRSModel();
    protected Map<Class, List<EPSGEntry>> objectCache2D = new HashMap<Class, List<EPSGEntry>>();
    protected Map<Class, List<EPSGEntry>> objectCache3D = new HashMap<Class, List<EPSGEntry>>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public static ICRSModel getDefault() {
        return me;
    }

    GeoTools_CRSModel() {
        this.defaults2D.put(Ellipsoid.class, new EPSGEntry("7030", (AuthorityFactory)this.dAFactory));
        this.defaults2D.put(PrimeMeridian.class, new EPSGEntry("8901", (AuthorityFactory)this.dAFactory));
        this.defaults2D.put(GeodeticDatum.class, new EPSGEntry("6326", (AuthorityFactory)this.dAFactory));
        this.defaults2D.put(EllipsoidalCS.class, new EPSGEntry("6422", (AuthorityFactory)this.csAFactory));
        this.defaults2D.put(CartesianCS.class, new EPSGEntry("4400", (AuthorityFactory)this.csAFactory));
        this.defaults2D.put(GeographicCRS.class, new EPSGEntry("4326", (AuthorityFactory)this.crsAFactory));
        this.defaults2D.put(Conversion.class, new EPSGEntry("16032", (AuthorityFactory)this.opAFactory));
        this.defaults2D.put(ProjectedCRS.class, new EPSGEntry("32632", (AuthorityFactory)this.crsAFactory));
        this.defaults3D.put(EllipsoidalCS.class, new EPSGEntry("6423", (AuthorityFactory)this.opAFactory));
        this.defaults3D.put(CartesianCS.class, new EPSGEntry("6500", (AuthorityFactory)this.opAFactory));
        this.defaults3D.put(GeographicCRS.class, new EPSGEntry("4979", (AuthorityFactory)this.opAFactory));
    }

    public EPSGEntry getDefaultEntry(Class cl, String hint) {
        if (hint != null && hint.equals("3D")) {
            return this.defaults3D.get(cl);
        }
        return this.defaults2D.get(cl);
    }

    @Override
    public <T extends IdentifiedObject> T getDefaultObject(Class<T> cl, String hint) throws FactoryException {
        EPSGEntry entry = this.getDefaultEntry(cl, hint);
        return (T)((IdentifiedObject)cl.cast(this.createObject(entry.getCode())));
    }

    @Override
    public List<EPSGEntry> getSupportedObjects(Class<? extends IdentifiedObject> cl, String hint) throws FactoryException {
        List<EPSGEntry> result;
        if (CoordinateSystemAxis.class.isAssignableFrom(cl)) {
            return new Vector<EPSGEntry>();
        }
        int dim = hint != null && hint.equals("3D") ? 3 : 2;
        List<EPSGEntry> list = result = dim == 3 ? this.objectCache3D.get(cl) : this.objectCache2D.get(cl);
        if (result != null) {
            return new Vector<EPSGEntry>(result);
        }
        Set codes = null;
        AuthorityFactory af = this.getAuthorityFactoryFor(cl);
        codes = af.getAuthorityCodes(cl);
        boolean isGCRS = GeographicCRS.class.isAssignableFrom(cl);
        boolean isCS = CoordinateSystem.class.isAssignableFrom(cl);
        result = new Vector<EPSGEntry>();
        if (codes != null && codes.size() != 0) {
            for (String code : codes) {
                String msg;
                boolean isOK = true;
                if (isGCRS && !this.correctGCRSDimension(code, dim)) {
                    isOK = false;
                }
                if (isCS && !this.correctCSDimension(code, dim)) {
                    isOK = false;
                }
                if (this.checkBeforeInsert || Conversion.class.isAssignableFrom(cl)) {
                    try {
                        af.createObject(code);
                    }
                    catch (Exception e) {
                        msg = Res.get(Res.WIDGETS, "err.CreateObject", code);
                        LOGGER.log(Level.FINE, String.valueOf(msg) + " - " + e.toString(), e);
                        isOK = false;
                    }
                }
                if (!isOK) continue;
                try {
                    String name = af.getDescriptionText(code).toString();
                    result.add(new EPSGEntry(code, name));
                }
                catch (Exception e) {
                    msg = Res.get(Res.WIDGETS, "err.GetName", code);
                    LOGGER.log(Level.FINE, String.valueOf(msg) + " - " + e.toString(), e);
                }
            }
        }
        if (dim == 3) {
            this.objectCache3D.put(cl, result);
        } else {
            this.objectCache2D.put(cl, result);
        }
        return new Vector<EPSGEntry>(result);
    }

    protected boolean correctGCRSDimension(String epsgCode, int dim) {
        Integer c;
        if (dim == 2 & ((c = Integer.valueOf(Integer.parseInt(epsgCode))) >= 4001 && c <= 4326 || c >= 4600 && c <= 4904)) {
            return true;
        }
        return dim == 3 & (c >= 4327 && c <= 4388 || c >= 4931 && c < 5000);
    }

    protected boolean correctCSDimension(String epsgCode, int dim) {
        try {
            CoordinateSystem cs = this.csAFactory.createCoordinateSystem(epsgCode);
            return dim == cs.getDimension();
        }
        catch (FactoryException fe) {
            String msg = Res.get(Res.WIDGETS, "err.CreateObject", epsgCode);
            LOGGER.log(Level.FINE, msg);
            return false;
        }
    }

    public String getFormattedDescription(Class cl, String epsgCode) throws FactoryException {
        EllipsoidalCS o = null;
        String result = "";
        String delim = String.valueOf(Res.get(Res.CRS, "delimiter")) + " ";
        String ret = UI.getMultiLineNewLine();
        if (Ellipsoid.class.isAssignableFrom(cl)) {
            Ellipsoid el = this.createEllipsoid(epsgCode);
            String unit = " " + el.getAxisUnit().toString();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.SemiMajorAxis") + delim + el.getSemiMajorAxis() + unit;
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.SemiMinorAxis") + delim + el.getSemiMinorAxis() + unit;
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.InvFlat") + delim + el.getInverseFlattening() + unit;
            o = el;
        } else if (PrimeMeridian.class.isAssignableFrom(cl)) {
            PrimeMeridian pm = this.createPrimeMeridian(epsgCode);
            String unit = " " + pm.getAngularUnit().toString();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.GreenwichLong") + delim + pm.getGreenwichLongitude() + unit;
            o = pm;
        } else if (GeodeticDatum.class.isAssignableFrom(cl)) {
            GeodeticDatum gd = this.createGeodeticDatum(epsgCode);
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.EL") + delim + gd.getEllipsoid().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.PM") + delim + gd.getPrimeMeridian().getName().getCode();
            if (gd.getAnchorPoint() != null) {
                String anchor = gd.getAnchorPoint().toString();
                int i = anchor.indexOf("Fundamental point: ");
                if (i == 0) {
                    anchor = anchor.substring(19);
                }
                anchor.replace("Fundamental point:", "");
                result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.GD.Origin") + delim + anchor;
            }
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.AreaOfUse") + delim + gd.getValidArea().getDescription().toString();
            o = gd;
        } else if (EllipsoidalCS.class.isAssignableFrom(cl)) {
            EllipsoidalCS eCS;
            o = eCS = this.createEllipsoidalCS(epsgCode);
        } else if (CartesianCS.class.isAssignableFrom(cl)) {
            CartesianCS cCS = this.createCartesianCS(epsgCode);
            o = cCS;
        } else if (GeographicCRS.class.isAssignableFrom(cl)) {
            GeographicCRS gCRS = this.createGeographicCRS(epsgCode);
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.CS") + delim + gCRS.getCoordinateSystem().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.GD") + delim + gCRS.getDatum().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.Scope") + delim + gCRS.getScope().toString();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.AreaOfUse") + delim + gCRS.getValidArea().getDescription().toString();
            o = gCRS;
        } else if (ProjectedCRS.class.isAssignableFrom(cl)) {
            ProjectedCRS pCRS = this.createProjectedCRS(epsgCode);
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.GCRS") + delim + pCRS.getBaseCRS().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.CS") + delim + pCRS.getCoordinateSystem().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.PRO") + delim + pCRS.getConversionFromBase().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.Scope") + delim + pCRS.getScope().toString();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.AreaOfUse") + delim + pCRS.getValidArea().getDescription().toString();
            o = pCRS;
        } else if (Conversion.class.isAssignableFrom(cl)) {
            Conversion conv = this.createConversion(epsgCode);
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.METHOD") + delim + conv.getMethod().getName().getCode();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.Scope") + delim + conv.getScope().toString();
            result = String.valueOf(result) + ret + Res.get(Res.CRS, "x.AreaOfUse") + delim + conv.getValidArea().getDescription().toString();
            o = conv;
        }
        if (o != null) {
            String temp = String.valueOf(Res.get(Res.CRS, "x.EPSGCode")) + delim + GeoTools_CRSModel.getCode((IdentifiedObject)o);
            temp = String.valueOf(temp) + ret + Res.get(Res.CRS, "x.Name") + delim + GeoTools_CRSModel.getName((IdentifiedObject)o);
            result = String.valueOf(temp) + result;
        }
        if (result.length() > 0) {
            return String.valueOf(UI.getMultiLinePrefix()) + result + UI.getMultiLineSuffix();
        }
        return Res.get(Res.CRS, "nodesc");
    }

    protected static String getCode(IdentifiedObject o) {
        Iterator it = o.getIdentifiers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        return ((Identifier)it.next()).getCode();
    }

    protected static String getName(IdentifiedObject o) {
        return o.getName().getCode();
    }

    @Override
    public EPSGEntry getEntryFor(IdentifiedObject o) {
        String code = GeoTools_CRSModel.getCode(o);
        String name = GeoTools_CRSModel.getName(o);
        if (code == null) {
            if (name == null) {
                return EPSGEntry.OTHER;
            }
            return new EPSGEntry(name);
        }
        if (name == null) {
            try {
                name = this.crsAFactory.getDescriptionText(code).toString();
            }
            catch (Exception e) {
                String msg = Res.get(Res.WIDGETS, "err.GetName", code);
                LOGGER.log(Level.FINE, String.valueOf(msg) + " - " + e.toString(), e);
            }
        }
        return new EPSGEntry(code, name);
    }

    @Override
    public Ellipsoid createEllipsoid(String name, String sa, String sb, String sInvFlat, Unit lUnit) throws FactoryException {
        if (Util.isEmpty(sa) || Util.isEmpty(sb) && Util.isEmpty(sInvFlat)) {
            throw new FactoryException(Res.get("err.ElParams"));
        }
        double a = C.getdoubleX(sa, 0.0);
        double b = C.getdoubleX(sb, 0.0);
        double invFlat = C.getdoubleX(sInvFlat, 0.0);
        return this.createEllipsoid(name, a, b, invFlat, lUnit);
    }

    @Override
    public Ellipsoid createEllipsoid(String name, double a, double b, double invFlat, Unit lUnit) throws FactoryException {
        if (invFlat == 0.0) {
            return this.dFactory.createEllipsoid(Collections.singletonMap("name", name), a, b, lUnit);
        }
        return this.dFactory.createFlattenedSphere(Collections.singletonMap("name", name), a, invFlat, lUnit);
    }

    @Override
    public Ellipsoid createEllipsoid(String epsgCode) throws FactoryException {
        return this.dAFactory.createEllipsoid(epsgCode);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String name, double lon, Unit aUnit) throws FactoryException {
        return this.dFactory.createPrimeMeridian(Collections.singletonMap("name", name), lon, aUnit);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String epsgCode) throws FactoryException {
        return this.dAFactory.createPrimeMeridian(epsgCode);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String name, Ellipsoid el, PrimeMeridian pm) throws FactoryException {
        return this.dFactory.createGeodeticDatum(Collections.singletonMap("name", name), el, pm);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String epsgCode) throws FactoryException {
        return this.dAFactory.createGeodeticDatum(epsgCode);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String name, String abb, AxisDirection direction, Unit unit) throws FactoryException {
        return this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", name), abb, direction, unit);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        return this.csFactory.createEllipsoidalCS(Collections.singletonMap("name", name), axis0, axis1);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        return this.csFactory.createEllipsoidalCS(Collections.singletonMap("name", name), axis0, axis1, axis2);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String epsgCode) throws FactoryException {
        return this.csAFactory.createEllipsoidalCS(epsgCode);
    }

    @Override
    public CartesianCS createCartesianCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        return this.csFactory.createCartesianCS(Collections.singletonMap("name", name), axis0, axis1);
    }

    @Override
    public CartesianCS createCartesianCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        return this.csFactory.createCartesianCS(Collections.singletonMap("name", name), axis0, axis1, axis2);
    }

    @Override
    public CartesianCS createCartesianCS(String epsgCode) throws FactoryException {
        return this.csAFactory.createCartesianCS(epsgCode);
    }

    @Override
    public GeographicCRS createGeographicCRS(String name, GeodeticDatum gd, EllipsoidalCS eCS) throws FactoryException {
        return this.crsFactory.createGeographicCRS(Collections.singletonMap("name", name), gd, eCS);
    }

    @Override
    public GeographicCRS createGeographicCRS(String epsgCode) throws FactoryException {
        return this.crsAFactory.createGeographicCRS(epsgCode);
    }

    @Override
    public Conversion createConversion(String epsgCode) throws FactoryException {
        return (Conversion)this.opAFactory.createCoordinateOperation(epsgCode);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String name, GeographicCRS gCRS, CartesianCS cCS, Conversion conv) throws FactoryException {
        FactoryGroup fg = new FactoryGroup();
        return fg.createProjectedCRS(Collections.singletonMap("name", name), gCRS, conv, cCS);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String epsgCode) throws FactoryException {
        return this.crsAFactory.createProjectedCRS(epsgCode);
    }

    @Override
    public IdentifiedObject createObject(String epsgCode) throws FactoryException {
        IdentifiedObject o = this.createObject(epsgCode, (AuthorityFactory)this.dAFactory);
        if (o != null) {
            return o;
        }
        o = this.createObject(epsgCode, (AuthorityFactory)this.csAFactory);
        if (o != null) {
            return o;
        }
        o = this.createObject(epsgCode, (AuthorityFactory)this.crsAFactory);
        if (o != null) {
            return o;
        }
        o = this.createObject(epsgCode, (AuthorityFactory)this.opAFactory);
        if (o != null) {
            return o;
        }
        throw new FactoryException(Res.get("err.CreateObject"));
    }

    protected IdentifiedObject createObject(String epsgCode, AuthorityFactory af) {
        try {
            return af.createObject(epsgCode);
        }
        catch (FactoryException fe) {
            return null;
        }
    }

    protected AuthorityFactory getAuthorityFactoryFor(Class<? extends IdentifiedObject> cl) throws FactoryException {
        DatumAuthorityFactory af = null;
        if (Ellipsoid.class.isAssignableFrom(cl) || PrimeMeridian.class.isAssignableFrom(cl) || Datum.class.isAssignableFrom(cl)) {
            af = this.dAFactory;
        } else if (CoordinateSystem.class.isAssignableFrom(cl) || Unit.class.isAssignableFrom(cl)) {
            af = this.csAFactory;
        } else if (CoordinateReferenceSystem.class.isAssignableFrom(cl)) {
            af = this.crsAFactory;
        } else if (Conversion.class.isAssignableFrom(cl)) {
            af = this.opAFactory;
        } else {
            throw new FactoryException(Res.get(Res.WIDGETS, "err.NoFactory", cl.toString()));
        }
        return af;
    }
}

