/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.model;

import java.util.List;
import javax.units.Unit;
import org.geowidgets.crs.model.EPSGEntry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ICRSModel {
    public List<EPSGEntry> getSupportedObjects(Class<? extends IdentifiedObject> var1, String var2) throws FactoryException;

    public EPSGEntry getDefaultEntry(Class<? extends IdentifiedObject> var1, String var2);

    public <T extends IdentifiedObject> T getDefaultObject(Class<T> var1, String var2) throws FactoryException;

    public String getFormattedDescription(Class<? extends IdentifiedObject> var1, String var2) throws FactoryException;

    public EPSGEntry getEntryFor(IdentifiedObject var1);

    public Ellipsoid createEllipsoid(String var1, String var2, String var3, String var4, Unit var5) throws FactoryException;

    public Ellipsoid createEllipsoid(String var1, double var2, double var4, double var6, Unit var8) throws FactoryException;

    public Ellipsoid createEllipsoid(String var1) throws FactoryException;

    public PrimeMeridian createPrimeMeridian(String var1, double var2, Unit var4) throws FactoryException;

    public PrimeMeridian createPrimeMeridian(String var1) throws FactoryException;

    public GeodeticDatum createGeodeticDatum(String var1, Ellipsoid var2, PrimeMeridian var3) throws FactoryException;

    public GeodeticDatum createGeodeticDatum(String var1) throws FactoryException;

    public CoordinateSystemAxis createCoordinateSystemAxis(String var1, String var2, AxisDirection var3, Unit var4) throws FactoryException;

    public EllipsoidalCS createEllipsoidalCS(String var1, CoordinateSystemAxis var2, CoordinateSystemAxis var3) throws FactoryException;

    public EllipsoidalCS createEllipsoidalCS(String var1, CoordinateSystemAxis var2, CoordinateSystemAxis var3, CoordinateSystemAxis var4) throws FactoryException;

    public EllipsoidalCS createEllipsoidalCS(String var1) throws FactoryException;

    public CartesianCS createCartesianCS(String var1, CoordinateSystemAxis var2, CoordinateSystemAxis var3) throws FactoryException;

    public CartesianCS createCartesianCS(String var1, CoordinateSystemAxis var2, CoordinateSystemAxis var3, CoordinateSystemAxis var4) throws FactoryException;

    public CartesianCS createCartesianCS(String var1) throws FactoryException;

    public GeographicCRS createGeographicCRS(String var1, GeodeticDatum var2, EllipsoidalCS var3) throws FactoryException;

    public GeographicCRS createGeographicCRS(String var1) throws FactoryException;

    public Conversion createConversion(String var1) throws FactoryException;

    public ProjectedCRS createProjectedCRS(String var1, GeographicCRS var2, CartesianCS var3, Conversion var4) throws FactoryException;

    public ProjectedCRS createProjectedCRS(String var1) throws FactoryException;

    public IdentifiedObject createObject(String var1) throws FactoryException;
}

