/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.geowidgets.crs.widgets.propertysheet.eclipse.PropertySheetViewer;
import org.geowidgets.crs.widgets.propertysheet.propertysources.CS_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.EL_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.GCRS_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.GD_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.PCRS_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.PM_PropertySource;
import org.geowidgets.crs.widgets.propertysheet.propertysources.PROJ_PropertySource;
import org.geowidgets.framework.basewidgets.propertysheet.PropertySheetNotSorter;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSElementPropertyViewer<T extends IdentifiedObject>
extends Composite {
    protected PropertySheetViewer prop;
    protected T root;

    public CRSElementPropertyViewer(Composite parent, int style, T content) {
        super(parent, style);
        this.initTree(content);
    }

    protected void initTree(T root) {
        this.setLayout((Layout)new FillLayout());
        PropertySheetEntry entry = new PropertySheetEntry();
        entry.setPropertySourceProvider((IPropertySourceProvider)new CRSPropertySourceProvicer(root.getClass()));
        this.prop = new PropertySheetViewer(this);
        this.prop.setRootEntry((IPropertySheetEntry)entry);
        this.prop.setSorter(new PropertySheetNotSorter());
        this.setContent(root);
    }

    public boolean setContent(T root) {
        if (root == null) {
            return false;
        }
        this.root = root;
        this.prop.setInput(new Object[]{root});
        return true;
    }

    public T getContent() {
        return (T)((IdentifiedObject)this.prop.getInput());
    }

    public static class CRSPropertySourceProvicer
    implements IPropertySourceProvider {
        Class topClass;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;

        public CRSPropertySourceProvicer(Class topClass) {
            this.topClass = topClass;
        }

        public IPropertySource getPropertySource(Object object) {
            if (object instanceof Ellipsoid) {
                return new EL_PropertySource((Ellipsoid)object, Ellipsoid.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof PrimeMeridian) {
                return new PM_PropertySource((PrimeMeridian)object, PrimeMeridian.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof GeodeticDatum) {
                return new GD_PropertySource((GeodeticDatum)object, (IPropertySourceProvider)this, GeodeticDatum.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof EllipsoidalCS) {
                return new CS_PropertySource<EllipsoidalCS>((EllipsoidalCS)object, (IPropertySourceProvider)this, EllipsoidalCS.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof CartesianCS) {
                return new CS_PropertySource<CartesianCS>((CartesianCS)object, (IPropertySourceProvider)this, CartesianCS.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof Conversion) {
                return new PROJ_PropertySource((Conversion)object, Conversion.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof GeographicCRS) {
                return new GCRS_PropertySource((GeographicCRS)object, (IPropertySourceProvider)this, GeographicCRS.class.isAssignableFrom(this.topClass));
            }
            if (object instanceof ProjectedCRS) {
                return new PCRS_PropertySource((ProjectedCRS)object, (IPropertySourceProvider)this, ProjectedCRS.class.isAssignableFrom(this.topClass));
            }
            return null;
        }
    }
}

