/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboCellEditor;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboLabelProvider;
import org.geowidgets.units.model.IUnitModel;

public class UnitComboPropertyDescriptor
extends PropertyDescriptor {
    public static int UNIT_ALL = -1;
    public static int UNIT_LINEAR = 0;
    public static int UNIT_ANGULAR = 1;
    protected static IUnitModel model = GWFactoryFinder.getUnitModel();
    protected List<String> entries;

    public UnitComboPropertyDescriptor(Object id, int unitType) {
        super(id, UnitComboPropertyDescriptor.getLabel(unitType));
        this.entries = model.getSupportedUnits(unitType);
    }

    protected static String getLabel(int unitType) {
        if (unitType == 0) {
            return Res.get(Res.CRS, "x.UnitLinear");
        }
        if (unitType == 1) {
            return Res.get(Res.CRS, "x.UnitAngular");
        }
        return Res.get(Res.CRS, "x.Unit");
    }

    public CellEditor createPropertyEditor(Composite parent) {
        GeneralComboCellEditor<String> editor = new GeneralComboCellEditor<String>(parent, this.entries, false, this.getLabelProvider());
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public ILabelProvider getLabelProvider() {
        if (this.isLabelProviderSet()) {
            return super.getLabelProvider();
        }
        return new GeneralComboLabelProvider();
    }
}

