/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS_PropertySource<CS extends CoordinateSystem>
extends _CRS_PropertySource<CS> {
    protected static final String PROPERTY_AXIS1 = "Axis1";
    protected static final String PROPERTY_AXIS2 = "Axis2";
    protected IPropertyDescriptor[] propertyDescriptors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CS_PropertySource(CS cs, IPropertySourceProvider prov, boolean showNameField) {
        super("2D", prov, showNameField);
        this.setCS(cs);
    }

    public CS getCS() {
        return (CS)((CoordinateSystem)this.object);
    }

    public void setCS(CS object) {
        if (object == null) {
            return;
        }
        this.object = object;
    }

    @Override
    public void createObjectFromCode(String code) throws FactoryException {
        if (EllipsoidalCS.class.isAssignableFrom(((CoordinateSystem)this.object).getClass())) {
            this.setCS(crsModel.createEllipsoidalCS(code));
        } else if (CartesianCS.class.isAssignableFrom(((CoordinateSystem)this.object).getClass())) {
            this.setCS(crsModel.createCartesianCS(code));
        }
    }

    @Override
    public void createObjectFromParameters() throws FactoryException {
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return CS_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return CS_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_AXIS1)) {
            return ((CoordinateSystem)this.object).getAxis(0).getDirection().name();
        }
        if (id.equals(PROPERTY_AXIS2)) {
            return ((CoordinateSystem)this.object).getAxis(1).getDirection().name();
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            super.setNameOrCode(id, value);
        }
        catch (FactoryException e) {
            LOGGER.throwing("CS_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(false);
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_AXIS1, Res.get(Res.CRS, "x.Axis.0")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_AXIS2, Res.get(Res.CRS, "x.Axis.1")));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

