/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import javax.units.Unit;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.propertysheet.UnitComboPropertyDescriptor;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.FloatingPointPropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Ellipsoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EL_PropertySource
extends _CRS_PropertySource<Ellipsoid> {
    protected static final String PROPERTY_A = "a";
    protected static final String PROPERTY_B = "b";
    protected static final String PROPERTY_INVFLAT = "InvFlat";
    protected static final String PROPERTY_UNIT = "Unit";
    protected IPropertyDescriptor[] propertyDescriptors;
    protected boolean custom;
    protected double a;
    protected double b;
    protected double invFlat;
    protected Unit lUnit;
    protected boolean isIvfDefinitive;

    public EL_PropertySource(Ellipsoid el, boolean showNameField) {
        super("2D", null, showNameField);
        this.setEllipsoid(el);
    }

    public void setEllipsoid(Ellipsoid object) {
        if (object == null) {
            return;
        }
        this.object = object;
        this.entry = EPSGEntry.getEntryFor((IdentifiedObject)object);
        this.a = object.getSemiMajorAxis();
        this.b = object.getSemiMinorAxis();
        this.invFlat = object.getInverseFlattening();
        this.isIvfDefinitive = object.isIvfDefinitive();
        this.lUnit = object.getAxisUnit();
    }

    @Override
    protected void createObjectFromCode(String code) throws FactoryException {
        this.setEllipsoid(crsModel.createEllipsoid(code));
    }

    @Override
    protected void createObjectFromParameters() throws FactoryException {
        if (!this.entry.isCustom()) {
            this.entry = EPSGEntry.OTHER;
        }
        if (this.isIvfDefinitive) {
            this.b = 0.0;
        } else {
            this.invFlat = 0.0;
        }
        this.setEllipsoid(crsModel.createEllipsoid(this.entry.getName(), this.a, this.b, this.invFlat, this.lUnit));
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return EL_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return EL_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_A)) {
            return ((Ellipsoid)this.object).getSemiMajorAxis();
        }
        if (id.equals(PROPERTY_B)) {
            return ((Ellipsoid)this.object).getSemiMinorAxis();
        }
        if (id.equals(PROPERTY_INVFLAT)) {
            return ((Ellipsoid)this.object).getInverseFlattening();
        }
        if (id.equals(PROPERTY_UNIT)) {
            try {
                return uModel.getUnitName(((Ellipsoid)this.object).getAxisUnit());
            }
            catch (FactoryException fe) {
                return UNKNOWN;
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            super.setNameOrCode(id, value);
            if (id.equals(PROPERTY_A)) {
                this.a = (Double)value;
                this.createObjectFromParameters();
            } else if (id.equals(PROPERTY_B)) {
                this.b = (Double)value;
                this.isIvfDefinitive = false;
                this.createObjectFromParameters();
            } else if (id.equals(PROPERTY_INVFLAT)) {
                this.invFlat = (Double)value;
                this.isIvfDefinitive = true;
                this.createObjectFromParameters();
            } else if (id.equals(PROPERTY_UNIT)) {
                this.lUnit = uModel.getUnit(value.toString());
                this.createObjectFromParameters();
            }
        }
        catch (FactoryException e) {
            LOGGER.throwing("EL_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(true);
            result.add((IPropertyDescriptor)new FloatingPointPropertyDescriptor(PROPERTY_A, Res.get(Res.CRS, "x.a"), 0.0, Double.MAX_VALUE));
            result.add((IPropertyDescriptor)new FloatingPointPropertyDescriptor(PROPERTY_B, Res.get(Res.CRS, "x.b"), 0.0, Double.MAX_VALUE));
            result.add((IPropertyDescriptor)new FloatingPointPropertyDescriptor(PROPERTY_INVFLAT, Res.get(Res.CRS, "x.1f"), 0.0, Double.MAX_VALUE));
            result.add((IPropertyDescriptor)new UnitComboPropertyDescriptor(PROPERTY_UNIT, 0));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

