/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboPropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCRS_PropertySource
extends _CRS_PropertySource<GeographicCRS> {
    protected static final String PROPERTY_SCOPE = "Scope";
    protected static final String PROPERTY_CS = "CS";
    protected static final String PROPERTY_GD = "GD";
    protected GeodeticDatum gd;
    protected EllipsoidalCS cs;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GCRS_PropertySource(GeographicCRS gCRS, IPropertySourceProvider prov, boolean showNameField) {
        super("2D", prov, showNameField);
        this.setCRS(gCRS);
    }

    public void setCRS(GeographicCRS object) {
        if (object == null) {
            return;
        }
        this.object = object;
        this.entry = EPSGEntry.getEntryFor((IdentifiedObject)object);
        this.gd = (GeodeticDatum)object.getDatum();
        this.cs = (EllipsoidalCS)object.getCoordinateSystem();
    }

    @Override
    public void createObjectFromCode(String code) throws FactoryException {
        this.setCRS(crsModel.createGeographicCRS(code));
    }

    @Override
    public void createObjectFromParameters() throws FactoryException {
        if (!this.entry.isCustom()) {
            this.entry = EPSGEntry.OTHER;
        }
        this.setCRS(crsModel.createGeographicCRS(this.entry.getName(), this.gd, this.cs));
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return GCRS_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return GCRS_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_CS)) {
            return (EllipsoidalCS)((GeographicCRS)this.object).getCoordinateSystem();
        }
        if (id.equals(PROPERTY_GD)) {
            return (GeodeticDatum)((GeographicCRS)this.object).getDatum();
        }
        if (id.equals(PROPERTY_SCOPE)) {
            InternationalString scope = ((GeographicCRS)this.object).getScope();
            return scope == null ? UNKNOWN : scope.toString();
        }
        if (id.equals("Area")) {
            return this.getAreaDescription(((GeographicCRS)this.object).getValidArea());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            GeodeticDatum temp;
            if (super.setNameOrCode(id, value)) {
                return;
            }
            if (id.equals(PROPERTY_CS)) {
                EllipsoidalCS temp2 = this.updateChild(EllipsoidalCS.class, this.cs, value);
                if (temp2 != this.cs) {
                    this.cs = temp2;
                    this.createObjectFromParameters();
                }
            } else if (id.equals(PROPERTY_GD) && (temp = this.updateChild(GeodeticDatum.class, this.gd, value)) != this.gd) {
                this.gd = temp;
                this.createObjectFromParameters();
            }
        }
        catch (FactoryException e) {
            LOGGER.throwing("GCRS_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(true);
            List<EPSGEntry> csEntries = this.getSortedEntries(EllipsoidalCS.class, "2D", false);
            GeneralComboPropertyDescriptor<EPSGEntry> csDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_CS, Res.get(Res.CRS, "x.CS"), csEntries, false);
            csDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)csDescriptor);
            List<EPSGEntry> gdEntries = this.getSortedEntries(GeodeticDatum.class, null, true);
            GeneralComboPropertyDescriptor<EPSGEntry> gdDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_GD, Res.get(Res.CRS, "x.GD"), gdEntries, true);
            gdDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)gdDescriptor);
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_SCOPE, Res.get(Res.CRS, "x.Scope")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)"Area", Res.get(Res.CRS, "x.AreaOfUse")));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

