/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboPropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GD_PropertySource
extends _CRS_PropertySource<GeodeticDatum> {
    protected static final String PROPERTY_PM = "PM";
    protected static final String PROPERTY_EL = "EL";
    protected static final String PROPERTY_ORIGIN = "Origin";
    protected IPropertyDescriptor[] propertyDescriptors;
    protected PrimeMeridian pm;
    protected Ellipsoid el;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GD_PropertySource(GeodeticDatum gd, IPropertySourceProvider prov, boolean showNameField) {
        super("2D", prov, showNameField);
        this.setDatum(gd);
    }

    public void setDatum(GeodeticDatum object) {
        if (object == null) {
            return;
        }
        this.object = object;
        this.entry = EPSGEntry.getEntryFor((IdentifiedObject)object);
        this.pm = object.getPrimeMeridian();
        this.el = object.getEllipsoid();
    }

    @Override
    protected void createObjectFromCode(String code) throws FactoryException {
        this.setDatum(crsModel.createGeodeticDatum(code));
    }

    @Override
    protected void createObjectFromParameters() throws FactoryException {
        if (!this.entry.isCustom()) {
            this.entry = EPSGEntry.OTHER;
        }
        this.setDatum(crsModel.createGeodeticDatum(this.entry.getName(), this.el, this.pm));
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return GD_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return GD_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_PM)) {
            return ((GeodeticDatum)this.object).getPrimeMeridian();
        }
        if (id.equals(PROPERTY_EL)) {
            return ((GeodeticDatum)this.object).getEllipsoid();
        }
        if (id.equals(PROPERTY_ORIGIN)) {
            InternationalString anchor = ((GeodeticDatum)this.object).getAnchorPoint();
            if (anchor == null) {
                return UNKNOWN;
            }
            String origin = anchor.toString();
            int i = origin.indexOf("Fundamental point: ");
            if (i == 0) {
                origin = origin.substring(19);
            }
            origin.replace("Fundamental point:", "");
            return origin;
        }
        if (id.equals("Area")) {
            return this.getAreaDescription(((GeodeticDatum)this.object).getValidArea());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            Ellipsoid temp;
            super.setNameOrCode(id, value);
            if (id.equals(PROPERTY_PM)) {
                PrimeMeridian temp2 = this.updateChild(PrimeMeridian.class, this.pm, value);
                if (temp2 != this.pm) {
                    this.pm = temp2;
                    this.createObjectFromParameters();
                }
            } else if (id.equals(PROPERTY_EL) && (temp = this.updateChild(Ellipsoid.class, this.el, value)) != this.el) {
                this.el = temp;
                this.createObjectFromParameters();
            }
        }
        catch (FactoryException e) {
            LOGGER.throwing("GD_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(true);
            List<EPSGEntry> csEntries = this.getSortedEntries(PrimeMeridian.class, null, true);
            GeneralComboPropertyDescriptor<EPSGEntry> pmDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_PM, Res.get(Res.CRS, "x.PM"), csEntries, false);
            pmDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)pmDescriptor);
            List<EPSGEntry> gdEntries = this.getSortedEntries(Ellipsoid.class, null, true);
            GeneralComboPropertyDescriptor<EPSGEntry> elDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_EL, Res.get(Res.CRS, "x.EL"), gdEntries, true);
            elDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)elDescriptor);
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_ORIGIN, Res.get(Res.CRS, "x.GD.Origin")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)"Area", Res.get(Res.CRS, "x.AreaOfUse")));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

