/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboPropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCRS_PropertySource
extends _CRS_PropertySource<ProjectedCRS> {
    protected static final String PROPERTY_SCOPE = "Scope";
    protected static final String PROPERTY_PROJ = "PROJ";
    protected static final String PROPERTY_CS = "CS";
    protected static final String PROPERTY_GCRS = "GCRS";
    protected Conversion conv;
    protected CartesianCS cs;
    protected GeographicCRS gCRS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public PCRS_PropertySource(ProjectedCRS pCRS, IPropertySourceProvider prov, boolean showNameField) {
        super("2D", prov, showNameField);
        this.setCRS(pCRS);
    }

    public void setCRS(ProjectedCRS object) {
        if (object == null) {
            return;
        }
        this.object = object;
        this.entry = EPSGEntry.getEntryFor((IdentifiedObject)object);
        this.conv = object.getConversionFromBase();
        this.cs = (CartesianCS)object.getCoordinateSystem();
        this.gCRS = (GeographicCRS)object.getBaseCRS();
    }

    @Override
    public void createObjectFromCode(String code) throws FactoryException {
        this.setCRS(crsModel.createProjectedCRS(code));
    }

    @Override
    public void createObjectFromParameters() throws FactoryException {
        if (!this.entry.isCustom()) {
            this.entry = EPSGEntry.OTHER;
        }
        this.setCRS(crsModel.createProjectedCRS(this.entry.getName(), this.gCRS, this.cs, this.conv));
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return PCRS_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return PCRS_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_PROJ)) {
            return ((ProjectedCRS)this.object).getConversionFromBase();
        }
        if (id.equals(PROPERTY_CS)) {
            return (CartesianCS)((ProjectedCRS)this.object).getCoordinateSystem();
        }
        if (id.equals(PROPERTY_GCRS)) {
            return (GeographicCRS)((ProjectedCRS)this.object).getBaseCRS();
        }
        if (id.equals(PROPERTY_SCOPE)) {
            InternationalString scope = ((ProjectedCRS)this.object).getScope();
            return scope == null ? UNKNOWN : scope.toString();
        }
        if (id.equals("Area")) {
            return this.getAreaDescription(((ProjectedCRS)this.object).getValidArea());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            GeographicCRS temp;
            if (super.setNameOrCode(id, value)) {
                return;
            }
            if (id.equals(PROPERTY_PROJ)) {
                Conversion temp2 = this.updateChild(Conversion.class, this.conv, value);
                if (temp2 != this.conv) {
                    this.conv = temp2;
                    this.createObjectFromParameters();
                }
            } else if (id.equals(PROPERTY_CS)) {
                CartesianCS temp3 = this.updateChild(CartesianCS.class, this.cs, value);
                if (temp3 != this.cs) {
                    this.cs = temp3;
                    this.createObjectFromParameters();
                }
            } else if (id.equals(PROPERTY_GCRS) && (temp = this.updateChild(GeographicCRS.class, this.gCRS, value)) != this.gCRS) {
                this.gCRS = temp;
                this.createObjectFromParameters();
            }
        }
        catch (FactoryException e) {
            LOGGER.throwing("PCRS_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(true);
            List<EPSGEntry> convEntries = this.getSortedEntries(Conversion.class, "2D", false);
            GeneralComboPropertyDescriptor<EPSGEntry> convDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_PROJ, Res.get(Res.CRS, "x.PRO"), convEntries, false);
            convDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)convDescriptor);
            List<EPSGEntry> csEntries = this.getSortedEntries(EllipsoidalCS.class, "2D", false);
            GeneralComboPropertyDescriptor<EPSGEntry> csDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_CS, Res.get(Res.CRS, "x.CS"), csEntries, false);
            csDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)csDescriptor);
            List<EPSGEntry> gCRSEntries = this.getSortedEntries(GeographicCRS.class, "2D", true);
            GeneralComboPropertyDescriptor<EPSGEntry> gdDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_GCRS, Res.get(Res.CRS, "x.GCRS"), gCRSEntries, true);
            gdDescriptor.setLabelProvider((ILabelProvider)_CRS_PropertySource.LABEL_CRS);
            result.add((IPropertyDescriptor)gdDescriptor);
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_SCOPE, Res.get(Res.CRS, "x.Scope")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)"Area", Res.get(Res.CRS, "x.AreaOfUse")));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

