/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import javax.units.Unit;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.propertysheet.UnitComboPropertyDescriptor;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.FloatingPointPropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.PrimeMeridian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_PropertySource
extends _CRS_PropertySource<PrimeMeridian> {
    protected static final String PROPERTY_LONGITUDE = "Longitude";
    protected static final String PROPERTY_UNIT = "Unit";
    protected IPropertyDescriptor[] propertyDescriptors;
    protected boolean custom;
    protected double longitude;
    protected Unit aUnit;

    public PM_PropertySource(PrimeMeridian pm, boolean showNameField) {
        super("2D", null, showNameField);
        this.setPrimeMeridian(pm);
    }

    public void setPrimeMeridian(PrimeMeridian object) {
        if (object == null) {
            return;
        }
        this.object = object;
        this.entry = EPSGEntry.getEntryFor((IdentifiedObject)object);
        this.longitude = object.getGreenwichLongitude();
        this.aUnit = object.getAngularUnit();
    }

    @Override
    protected void createObjectFromCode(String code) throws FactoryException {
        this.setPrimeMeridian(crsModel.createPrimeMeridian(code));
    }

    @Override
    protected void createObjectFromParameters() throws FactoryException {
        if (!this.entry.isCustom()) {
            this.entry = EPSGEntry.OTHER;
        }
        this.setPrimeMeridian(crsModel.createPrimeMeridian(this.entry.getName(), this.longitude, this.aUnit));
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return PM_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return PM_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_LONGITUDE)) {
            return ((PrimeMeridian)this.object).getGreenwichLongitude();
        }
        if (id.equals(PROPERTY_UNIT)) {
            try {
                return uModel.getUnitName(((PrimeMeridian)this.object).getAngularUnit());
            }
            catch (FactoryException fe) {
                return UNKNOWN;
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            super.setNameOrCode(id, value);
            if (id.equals(PROPERTY_LONGITUDE)) {
                this.longitude = (Double)value;
                this.createObjectFromParameters();
            } else if (id.equals(PROPERTY_UNIT)) {
                this.aUnit = uModel.getUnit(value.toString());
                this.createObjectFromParameters();
            }
        }
        catch (FactoryException e) {
            LOGGER.throwing("PM_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(true);
            result.add((IPropertyDescriptor)new FloatingPointPropertyDescriptor(PROPERTY_LONGITUDE, Res.get(Res.CRS, "x.GreenwichLong"), -360.0, 360.0));
            result.add((IPropertyDescriptor)new UnitComboPropertyDescriptor(PROPERTY_UNIT, 1));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

