/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geowidgets.crs.widgets.propertysheet.propertysources._CRS_PropertySource;
import org.geowidgets.framework.Res;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PROJ_PropertySource
extends _CRS_PropertySource<Conversion> {
    protected static final String PROPERTY_METHOD = "OperationMethod";
    protected static final String PROPERTY_SCOPE = "Scope";
    protected IPropertyDescriptor[] propertyDescriptors;

    public PROJ_PropertySource(Conversion conv, boolean showNameField) {
        super("2D", null, showNameField);
        this.setProjection(conv);
    }

    public void setProjection(Conversion object) {
        if (object == null) {
            return;
        }
        this.object = object;
    }

    @Override
    public void createObjectFromCode(String code) throws FactoryException {
        this.setProjection(crsModel.createConversion(code));
    }

    @Override
    public void createObjectFromParameters() throws FactoryException {
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("Name")) {
            return PROJ_PropertySource.getName(this.object);
        }
        if (id.equals("Info.Code")) {
            return PROJ_PropertySource.getCode(this.object);
        }
        if (id.equals(PROPERTY_METHOD)) {
            return PROJ_PropertySource.getName((IdentifiedObject)((Conversion)this.object).getMethod());
        }
        if (id.equals(PROPERTY_SCOPE)) {
            InternationalString scope = ((Conversion)this.object).getScope();
            return scope == null ? UNKNOWN : scope.toString();
        }
        if (id.equals("Area")) {
            return this.getAreaDescription(((Conversion)this.object).getValidArea());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            super.setNameOrCode(id, value);
        }
        catch (FactoryException e) {
            LOGGER.throwing("EL_PropertySource", "setPropertyValue", e);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List<IPropertyDescriptor> result = this.getBasicPropertyDescriptors(false);
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_METHOD, Res.get(Res.CRS, "x.METHOD")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)PROPERTY_SCOPE, Res.get(Res.CRS, "x.Scope")));
            result.add((IPropertyDescriptor)new PropertyDescriptor((Object)"Area", Res.get(Res.CRS, "x.AreaOfUse")));
            this.propertyDescriptors = result.toArray(new IPropertyDescriptor[result.size()]);
        }
        return this.propertyDescriptors;
    }
}

