/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.propertysheet.propertysources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.model.ICRSModel;
import org.geowidgets.crs.widgets.propertysheet.EPSGCodeLabelProvider;
import org.geowidgets.framework.GWFactoryFinder;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.basewidgets.propertysheet.GeneralComboPropertyDescriptor;
import org.geowidgets.units.model.IUnitModel;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class _CRS_PropertySource<T extends IdentifiedObject>
implements IPropertySource {
    protected static final String PROPERTY_NAME = "Name";
    protected static final String PROPERTY_CODE = "Info.Code";
    protected static final String PROPERTY_AREA = "Area";
    protected static final String UNKNOWN = Res.get("err.Unknown");
    protected static final ICRSModel crsModel = GWFactoryFinder.getCRSModel();
    protected static final IUnitModel uModel = GWFactoryFinder.getUnitModel();
    protected static final Logger LOGGER = GWFactoryFinder.getLoggerFactory().getLogger();
    protected static final LabelProvider LABEL_CRS = new CRSLabelProvider();
    protected IPropertySourceProvider prov;
    protected IPropertyDescriptor[] propertyDescriptors;
    protected boolean showNameField = true;
    protected String hints;
    protected T object;
    protected EPSGEntry entry;

    public _CRS_PropertySource(String hints, IPropertySourceProvider prov, boolean showNameField) {
        this.hints = hints;
        this.prov = prov;
        this.showNameField = showNameField;
    }

    public _CRS_PropertySource(String hints) {
        this.hints = hints;
    }

    public T getCurrentValue() {
        return this.object;
    }

    public Object getEditableValue() {
        return this.object;
    }

    public boolean setNameOrCode(Object id, Object value) throws FactoryException {
        if (id.equals(PROPERTY_NAME)) {
            if (value instanceof String) {
                this.entry = new EPSGEntry(value.toString());
                this.createObjectFromParameters();
            } else {
                EPSGEntry entry;
                if (value == null) {
                    value = EPSGEntry.OTHER;
                }
                if ((entry = (EPSGEntry)value).isCustom()) {
                    this.entry = new EPSGEntry(value.toString());
                    this.createObjectFromParameters();
                } else {
                    this.createObjectFromCode(entry.getCode());
                }
            }
            return true;
        }
        if (id.equals(PROPERTY_CODE)) {
            EPSGEntry entry;
            if (value instanceof EPSGEntry && !(entry = (EPSGEntry)value).isCustom()) {
                this.createObjectFromCode(entry.getCode());
            }
            return true;
        }
        return false;
    }

    public <T extends IdentifiedObject> T updateChild(Class<T> cl, T child, Object value) {
        if (value instanceof String) {
            value = new EPSGEntry(value.toString());
        }
        if (value instanceof EPSGEntry) {
            EPSGEntry entry = (EPSGEntry)value;
            IPropertySource ps = this.prov.getPropertySource(child);
            ps.setPropertyValue((Object)PROPERTY_NAME, (Object)entry);
            return (T)((IdentifiedObject)cl.cast(ps.getEditableValue()));
        }
        return (T)((IdentifiedObject)cl.cast(value));
    }

    protected abstract void createObjectFromCode(String var1) throws FactoryException;

    protected abstract void createObjectFromParameters() throws FactoryException;

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    protected static String getCode(IdentifiedObject o) {
        Iterator it = o.getIdentifiers().iterator();
        if (!it.hasNext()) {
            return EPSGEntry.OTHER.getCode();
        }
        return ((Identifier)it.next()).getCode();
    }

    protected static String getName(IdentifiedObject o) {
        return o.getName().getCode();
    }

    protected String getAreaDescription(Extent ex) {
        if (ex != null) {
            InternationalString area = ex.getDescription();
            return area == null ? Res.get("err.Unknown") : area.toString();
        }
        return Res.get("err.Unknown");
    }

    public List<IPropertyDescriptor> getBasicPropertyDescriptors(boolean allowCustom) {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        List<EPSGEntry> entries = this.getSortedEntries(this.object.getClass(), this.hints, allowCustom);
        if (this.showNameField) {
            GeneralComboPropertyDescriptor<EPSGEntry> textDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_NAME, Res.get(Res.CRS, "x.Name"), entries, true);
            result.add((IPropertyDescriptor)textDescriptor);
        }
        entries = new ArrayList<EPSGEntry>(entries);
        Collections.sort(entries, EPSGEntry.COMPARE_CODE);
        GeneralComboPropertyDescriptor<EPSGEntry> codeDescriptor = new GeneralComboPropertyDescriptor<EPSGEntry>(PROPERTY_CODE, Res.get(Res.CRS, "x.EPSGCode"), entries, false, (ILabelProvider)new EPSGCodeLabelProvider());
        result.add((IPropertyDescriptor)codeDescriptor);
        return result;
    }

    protected List<EPSGEntry> getSortedEntries(Class<? extends IdentifiedObject> cl, String hints, boolean allowCustom) {
        List<EPSGEntry> entries;
        try {
            entries = crsModel.getSupportedObjects(cl, hints);
        }
        catch (Exception e) {
            entries = new ArrayList<EPSGEntry>();
        }
        Collections.sort(entries);
        if (allowCustom) {
            entries.add(0, EPSGEntry.OTHER);
        }
        return entries;
    }

    public static class CRSLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof IdentifiedObject) {
                return _CRS_PropertySource.getName((IdentifiedObject)element);
            }
            if (element instanceof _CRS_PropertySource) {
                Object o = ((_CRS_PropertySource)element).getCurrentValue();
                return _CRS_PropertySource.getName(o);
            }
            return super.getText(element);
        }
    }
}

