/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.units.Unit;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JAxisDirComboBox;
import org.geowidgets.crs.widgets.swing.JUnitComboBox;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.geowidgets.framework.Res;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class JAxisAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = -7893589222277432131L;
    int unitType;
    protected JTextField t_AxisAbb;
    protected JAxisDirComboBox cb_AxisDir;
    protected JUnitComboBox cb_AxisUnit;
    static /* synthetic */ Class class$0;

    public JAxisAssemblyPanel(Color c, int unitType, int axisNum) {
        super("x.Axis." + axisNum, "x.Axis.Custom", c, CoordinateSystemAxis.class, null);
        this.unitType = unitType;
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC labelGBC = UI.getLabelGBC();
        ComfortGBC comboGBC = UI.getComboGBC();
        String uName = this.unitType == 1 ? "x.UnitAngular" : "x.UnitLinear";
        custom.add((Component)UI.createJLabel(Res.CRS, "x.Abb"), labelGBC.setPos(0, 1));
        custom.add((Component)UI.createJLabel(Res.CRS, "x.AxisDir"), labelGBC.setPos(0, 2));
        custom.add((Component)UI.createJLabel(Res.CRS, uName), labelGBC.setPos(0, 3));
        this.t_AxisAbb = UI.customize(new JTextField());
        this.cb_AxisDir = new JAxisDirComboBox();
        UI.customize(this.cb_AxisDir);
        this.cb_AxisUnit = new JUnitComboBox(this.unitType, true);
        UI.customize(this.cb_AxisUnit);
        custom.add((Component)this.t_AxisAbb, comboGBC.setPos(1, 1));
        custom.add((Component)this.cb_AxisDir, comboGBC.setPos(1, 2));
        custom.add((Component)this.cb_AxisUnit, comboGBC.setPos(1, 3));
    }

    protected void setToDefault() {
    }

    protected boolean updateInformationLabel(JTextArea standard, String dropdownText) {
        return true;
    }

    public CoordinateSystemAxis getAxis() throws FactoryException {
        Object temp = this.dropdown.getSelectedItem();
        String axis = temp == null ? EPSGEntry.OTHER.toString() : temp.toString();
        String abb = this.t_AxisAbb.getText();
        if (abb == null) {
            abb = "";
        }
        AxisDirection direction = this.cb_AxisDir.getSelectedAxisDirection();
        Unit unit = this.cb_AxisUnit.getSelectedUnit();
        return model.createCoordinateSystemAxis(axis, abb, direction, unit);
    }

    public void setAxis(CoordinateSystemAxis axis) {
        this.dropdown.setToolTipText(axis.getName().getCode());
        this.t_AxisAbb.setText(axis.getAbbreviation());
        this.cb_AxisDir.setAxisDirection(axis.getDirection());
        this.cb_AxisUnit.setSelectedUnit(axis.getUnit());
    }
}

