/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JAxisAssemblyPanel;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.geowidgets.framework.Res;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCSAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = 5085442240260997972L;
    Class csType;
    int dim;
    protected JAxisAssemblyPanel axPanel0;
    protected JAxisAssemblyPanel axPanel1;
    protected JAxisAssemblyPanel axPanel2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JCSAssemblyPanel(Color c, Class<? extends IdentifiedObject> csType, int dim) {
        super("x.CS", "x.CS.Custom", c, csType, String.valueOf(Integer.toString(dim)) + "D");
        this.csType = csType;
        this.dim = dim;
        this.setToDefault();
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC comboGBC = UI.getComboGBC();
        int unitType = CartesianCS.class.isAssignableFrom(this.cl) ? 0 : 1;
        this.axPanel0 = new JAxisAssemblyPanel(null, unitType, 0);
        this.axPanel0.setBackground(this.customPanelColor);
        custom.add((Component)this.axPanel0, comboGBC.setPos(0, 0));
        this.axPanel1 = new JAxisAssemblyPanel(null, unitType, 1);
        this.axPanel1.setBackground(this.customPanelColor);
        custom.add((Component)this.axPanel1, comboGBC.setPos(0, 1));
        if (this.dim == 3) {
            this.axPanel2 = new JAxisAssemblyPanel(null, unitType, 2);
            this.axPanel2.setBackground(this.customPanelColor);
            custom.add((Component)this.axPanel1, comboGBC.setPos(0, 2));
        }
    }

    public CoordinateSystem getCS() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            CoordinateSystemAxis axis0 = this.axPanel0.getAxis();
            CoordinateSystemAxis axis1 = this.axPanel1.getAxis();
            CoordinateSystemAxis axis2 = null;
            if (this.dim == 3) {
                axis2 = this.axPanel2.getAxis();
            }
            if (this.csType.equals(EllipsoidalCS.class)) {
                return this.dim == 3 ? model.createEllipsoidalCS(entry.getName(), axis0, axis1) : model.createEllipsoidalCS(entry.getName(), axis0, axis1, axis2);
            }
            if (this.csType.equals(CartesianCS.class)) {
                return this.dim == 3 ? model.createCartesianCS(entry.getName(), axis0, axis1) : model.createCartesianCS(entry.getName(), axis0, axis1, axis2);
            }
            throw new FactoryException(Res.get("err.UnknownType"));
        }
        try {
            if (this.csType.equals(EllipsoidalCS.class)) {
                return model.createEllipsoidalCS(entry.getCode());
            }
            if (this.csType.equals(CartesianCS.class)) {
                return model.createCartesianCS(entry.getCode());
            }
            throw new FactoryException(Res.get("err.UnknownType"));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCS(CoordinateSystem cs) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)cs);
        super.setToObject(entry);
        if (cs.getDimension() != this.dim) {
            this.dim = cs.getDimension();
            this.initCustomPanel(this.custom);
        }
        this.axPanel0.setAxis(cs.getAxis(0));
        this.axPanel1.setAxis(cs.getAxis(1));
        if (this.dim == 3) {
            this.axPanel2.setAxis(cs.getAxis(2));
        }
    }
}

