/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JUnitComboBox;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.geowidgets.framework.Res;
import org.geowidgets.framework.validation.impl.BackgroundColorNotifier;
import org.geowidgets.framework.validation.impl.CombinedValidator;
import org.geowidgets.framework.validation.impl.SimpleTextFieldValidator;
import org.geowidgets.framework.validation.swing.JValidatedTextComponent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.datum.Ellipsoid;

public class JEllipsoidAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = 3783996814048300581L;
    protected static final String ERR_PARAMS = Res.get(Res.WIDGETS, "err.ElParams");
    protected JUnitComboBox cb_EUnit;
    protected JTextField t_Ea;
    protected JTextField t_Eb;
    protected JTextField t_Flat;
    protected JValidatedTextComponent<JTextField> val_Ea;
    protected JValidatedTextComponent<JTextField> val_Eb;
    protected JValidatedTextComponent<JTextField> val_Flat;
    static /* synthetic */ Class class$0;

    public JEllipsoidAssemblyPanel(Color c) {
        super("x.EL", "x.EL.Custom", c, Ellipsoid.class, null);
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC labelGBC = UI.getLabelGBC();
        ComfortGBC comboGBC = UI.getComboGBC();
        custom.add((Component)UI.createJLabel(Res.CRS, "x.UnitLinear"), labelGBC.setPos(0, 2));
        custom.add((Component)UI.createJLabel(Res.CRS, "x.a"), labelGBC.setPos(0, 3));
        custom.add((Component)UI.createJLabel(Res.CRS, "x.b"), labelGBC.setPos(0, 4));
        custom.add((Component)UI.createJLabel(Res.CRS, "x.InvFlat"), labelGBC.setPos(0, 5));
        this.cb_EUnit = new JUnitComboBox(0, true);
        NumberFormatter formatter = new NumberFormatter();
        this.t_Ea = UI.customize(new JFormattedTextField(formatter));
        this.t_Eb = UI.customize(new JFormattedTextField(formatter));
        this.t_Flat = UI.customize(new JFormattedTextField(formatter));
        custom.add((Component)this.cb_EUnit, comboGBC.setPos(1, 2));
        custom.add((Component)this.t_Ea, comboGBC.setPos(1, 3));
        custom.add((Component)this.t_Eb, comboGBC.setPos(1, 4));
        custom.add((Component)this.t_Flat, comboGBC.setPos(1, 5));
        Color badColor = new Color(255, 50, 50);
        this.val_Ea = new JValidatedTextComponent<JTextField>(this.t_Ea, new SimpleTextFieldValidator(ERR_PARAMS, this.t_Ea, 1.0, Double.MAX_VALUE), new BackgroundColorNotifier(this.t_Ea, badColor, null));
        CombinedValidator combiVal = new CombinedValidator(ERR_PARAMS, CombinedValidator.COMBINE_OR, new SimpleTextFieldValidator(ERR_PARAMS, this.t_Eb, 1.0, Double.MAX_VALUE), new SimpleTextFieldValidator(ERR_PARAMS, this.t_Flat, 1.0, Double.MAX_VALUE));
        this.val_Eb = new JValidatedTextComponent<JTextField>(this.t_Eb, combiVal, new BackgroundColorNotifier(this.t_Eb, badColor, null));
        this.val_Flat = new JValidatedTextComponent<JTextField>(this.t_Flat, combiVal, new BackgroundColorNotifier(this.t_Flat, badColor, null));
    }

    public Ellipsoid getEllipsoid() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            if (!this.val_Ea.getValidator().getPreviousResult() && !this.val_Eb.getValidator().getPreviousResult()) {
                throw new FactoryException(ERR_PARAMS);
            }
            return model.createEllipsoid(entry.getName(), this.t_Ea.getText(), this.t_Eb.getText(), this.t_Flat.getText(), this.cb_EUnit.getSelectedUnit());
        }
        try {
            return model.createEllipsoid(entry.getCode());
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setEllipsoid(Ellipsoid el) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)el);
        super.setToObject(entry);
        this.t_Ea.setText(Double.toString(el.getSemiMajorAxis()));
        if (el.isIvfDefinitive()) {
            this.t_Flat.setText(Double.toString(el.getInverseFlattening()));
        } else {
            this.t_Eb.setText(Double.toString(el.getSemiMinorAxis()));
        }
        this.cb_EUnit.setSelectedUnit(el.getAxisUnit());
    }
}

