/*
 * Decompiled with CFR 0.152.
 */
package org.geowidgets.crs.widgets.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.MaBaUtils.ui.ComfortGBC;
import org.geowidgets.crs.model.EPSGEntry;
import org.geowidgets.crs.widgets.swing.JEllipsoidAssemblyPanel;
import org.geowidgets.crs.widgets.swing.JPrimeMeridianAssemblyPanel;
import org.geowidgets.crs.widgets.swing._AssemblyPanel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

public class JGeodeticDatumAssemblyPanel
extends _AssemblyPanel {
    private static final long serialVersionUID = 3762811584606580793L;
    protected JPrimeMeridianAssemblyPanel pmPanel;
    protected JEllipsoidAssemblyPanel elPanel;
    static /* synthetic */ Class class$0;

    public JGeodeticDatumAssemblyPanel(Color c) {
        super("x.GD", "x.GD.Custom", c, GeodeticDatum.class, null);
        this.initCustomPanel(this.custom);
    }

    protected void initCustomPanel(JPanel custom) {
        custom.setLayout(new GridBagLayout());
        ComfortGBC comboGBC = UI.getComboGBC();
        this.pmPanel = new JPrimeMeridianAssemblyPanel(null);
        this.pmPanel.setBackground(this.customPanelColor);
        this.elPanel = new JEllipsoidAssemblyPanel(null);
        this.elPanel.setBackground(this.customPanelColor);
        custom.add((Component)this.pmPanel, comboGBC.setPos(0, 0));
        custom.add((Component)this.elPanel, comboGBC.setPos(0, 1));
    }

    public GeodeticDatum getGeodeticDatum() throws FactoryException {
        EPSGEntry entry;
        Object temp = this.dropdown.getSelectedItem();
        EPSGEntry ePSGEntry = entry = temp == null ? EPSGEntry.OTHER : (EPSGEntry)temp;
        if (this.isCustom) {
            Ellipsoid el = this.elPanel.getEllipsoid();
            PrimeMeridian pm = this.pmPanel.getPrimeMeridian();
            return model.createGeodeticDatum(entry.getName(), el, pm);
        }
        try {
            return model.createGeodeticDatum(entry.getCode());
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setGeodeticDatum(GeodeticDatum gd) {
        EPSGEntry entry = model.getEntryFor((IdentifiedObject)gd);
        super.setToObject(entry);
        this.elPanel.setEllipsoid(gd.getEllipsoid());
        this.pmPanel.setPrimeMeridian(gd.getPrimeMeridian());
    }
}

